/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.fetch;

import java.util.Objects;
import net.jcip.annotations.Immutable;

public final class FetchRange {
    public static final FetchRange UNBOUNDED = new FetchRange(null, null);
    private final Limit from;
    private final Limit to;

    public FetchRange(Limit from, Limit to) {
        this.from = from;
        this.to = to;
    }

    public Limit from() {
        return this.from;
    }

    public Limit to() {
        return this.to;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FetchRange other = (FetchRange)obj;
        return Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("[from=");
        if (this.from == null) {
            sb.append("start");
        } else {
            sb.append(this.from);
        }
        sb.append(", to=");
        if (this.to == null) {
            sb.append("end");
        } else {
            sb.append(this.to);
        }
        sb.append(']');
        return sb.toString();
    }

    @Immutable
    public static final class Limit {
        private final String path;
        private final boolean includesPath;

        public Limit(String path, boolean includesPath) {
            this.path = path;
            this.includesPath = includesPath;
        }

        public String path() {
            return this.path;
        }

        public boolean includesPath() {
            return this.includesPath;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.includesPath ? 1231 : 1237);
            result = 31 * result + this.path.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Limit other = (Limit)obj;
            return this.includesPath == other.includesPath && this.path.equals(other.path);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append("[path=").append(this.path).append(", includesPath=").append(this.includesPath).append(']');
            return sb.toString();
        }
    }
}

