/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.fetch;

import com.pushtechnology.diffusion.command.commands.fetch.FetchTopicResult;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class FetchQueryResult {
    private final List<Map<String, String>> properties;
    private final List<IBytes> serialisedProperties;
    private final List<FetchTopicResult> results;
    private final boolean hasMore;

    public static FetchQueryResult createServerResult(List<IBytes> serialisedProperties, List<FetchTopicResult> results, boolean hasMore) {
        return new FetchQueryResult(Collections.emptyList(), serialisedProperties, results, hasMore);
    }

    public FetchQueryResult(List<Map<String, String>> properties, List<FetchTopicResult> results, boolean hasMore) {
        this(properties, Collections.emptyList(), results, hasMore);
    }

    private FetchQueryResult(List<Map<String, String>> properties, List<IBytes> serialisedProperties, List<FetchTopicResult> results, boolean hasMore) {
        this.properties = properties;
        this.serialisedProperties = serialisedProperties;
        this.results = results;
        this.hasMore = hasMore;
    }

    public List<Map<String, String>> properties() {
        return this.properties;
    }

    public List<IBytes> serialisedProperties() {
        return this.serialisedProperties;
    }

    public List<FetchTopicResult> results() {
        return this.results;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public int hashCode() {
        return Objects.hash(this.hasMore, this.results, this.properties, this.serialisedProperties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FetchQueryResult other = (FetchQueryResult)obj;
        return this.hasMore == other.hasMore && this.results.equals(other.results) && this.properties.equals(other.properties) && this.serialisedProperties.equals(other.serialisedProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("FetchQueryResult [properties=").append(this.properties.isEmpty() ? this.serialisedProperties : this.properties).append(", results=").append(this.results).append(", hasMore=").append(this.hasMore).append(']');
        return sb.toString();
    }
}

