/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.fetch;

import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.command.commands.fetch.FetchRange;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class FetchQuery {
    private final String selector;
    private final FetchRange range;
    private final Set<TopicType> topicTypes;
    private final boolean withValues;
    private final boolean withProperties;
    private final int limit;
    private final int maximumResultSize;
    private final int deepBranchDepth;
    private final int deepBranchLimit;
    private final boolean withUnpublishedDelayedTopics;
    private final boolean withSizes;

    public FetchQuery(String selector, FetchRange range, Set<TopicType> topicTypes, boolean withValues, boolean withProperties, int limit, int maximumResultSize, int deepBranchDepth, int deepBranchLimit, boolean withUnpublishedDelayedTopics, boolean withSizes) {
        this.withUnpublishedDelayedTopics = withUnpublishedDelayedTopics;
        this.selector = Objects.requireNonNull(selector);
        this.range = range;
        this.topicTypes = EnumSet.copyOf(Objects.requireNonNull(topicTypes));
        this.withValues = withValues;
        this.withProperties = withProperties;
        this.limit = limit;
        this.maximumResultSize = maximumResultSize;
        this.deepBranchDepth = deepBranchDepth;
        this.deepBranchLimit = deepBranchLimit;
        this.withSizes = withSizes;
    }

    public String getSelector() {
        return this.selector;
    }

    public FetchRange getRange() {
        return this.range;
    }

    public Set<TopicType> getTopicTypes() {
        return this.topicTypes;
    }

    public boolean isWithValues() {
        return this.withValues;
    }

    public boolean isWithProperties() {
        return this.withProperties;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getMaximumResultSize() {
        return this.maximumResultSize;
    }

    public int getDeepBranchDepth() {
        return this.deepBranchDepth;
    }

    public int getDeepBranchLimit() {
        return this.deepBranchLimit;
    }

    public boolean isWithUnpublishedDelayedTopics() {
        return this.withUnpublishedDelayedTopics;
    }

    public boolean isWithSizes() {
        return this.withSizes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.selector.hashCode();
        result = 31 * result + this.range.hashCode();
        result = 31 * result + this.topicTypes.hashCode();
        result = 31 * result + Boolean.hashCode(this.withValues);
        result = 31 * result + Boolean.hashCode(this.withProperties);
        result = 31 * result + this.limit;
        result = 31 * result + this.maximumResultSize;
        result = 31 * result + this.deepBranchDepth;
        result = 31 * result + this.deepBranchLimit;
        result = 31 * result + Boolean.hashCode(this.withUnpublishedDelayedTopics);
        result = 31 * result + Boolean.hashCode(this.withSizes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FetchQuery)) {
            return false;
        }
        FetchQuery other = (FetchQuery)obj;
        return this.selector.equals(other.selector) && this.range.equals(other.range) && this.topicTypes.equals(other.topicTypes) && this.withValues == other.withValues && this.withProperties == other.withProperties && this.limit == other.limit && this.maximumResultSize == other.maximumResultSize && this.deepBranchDepth == other.deepBranchDepth && this.deepBranchLimit == other.deepBranchLimit && this.withUnpublishedDelayedTopics == other.withUnpublishedDelayedTopics && this.withSizes == other.withSizes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("FetchQuery [selector=").append(this.selector).append(", range=").append(this.range).append(", topicTypes=").append(this.topicTypes).append(", withValues=").append(this.withValues).append(", withProperties=").append(this.withProperties).append(", limit=").append(this.limit).append(", maximumResultSize=").append(this.maximumResultSize).append(", deepBranchDepth=").append(this.deepBranchDepth).append(", deepBranchLimit=").append(this.deepBranchLimit).append(", withUnpublishedDelayedTopics=").append(this.withUnpublishedDelayedTopics).append(", withSizes=").append(this.withSizes).append(']');
        return sb.toString();
    }
}

