/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.topics;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class MissingTopicEvent {
    private final String theSelector;
    private final Map<String, String> theSessionProperties;
    private final List<String> theServers;
    private final List<Long> theServerIds;

    public MissingTopicEvent(String selector, Map<String, String> sessionProperties, List<String> servers, List<Long> serverIds) {
        this.theSelector = selector;
        this.theSessionProperties = Collections.unmodifiableMap(sessionProperties);
        this.theServers = Collections.unmodifiableList(servers);
        this.theServerIds = Collections.unmodifiableList(serverIds);
    }

    public String getSelector() {
        return this.theSelector;
    }

    public Map<String, String> getSessionProperties() {
        return this.theSessionProperties;
    }

    public List<String> getServers() {
        return this.theServers;
    }

    public List<Long> getServerIds() {
        return this.theServerIds;
    }

    public int hashCode() {
        return Objects.hash(this.theSelector, this.theSessionProperties, this.theServers, this.theServerIds);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MissingTopicEvent)) {
            return false;
        }
        MissingTopicEvent other = (MissingTopicEvent)obj;
        return this.theSelector.equals(other.theSelector) && this.theSessionProperties.equals(other.theSessionProperties) && this.theServers.equals(other.theServers) && this.theServerIds.equals(other.theServerIds);
    }

    public String toString() {
        return "MissingTopicEvent [Selector=" + this.theSelector + ", SessionProperties=" + String.valueOf(this.theSessionProperties) + ", Servers=" + String.valueOf(this.theServers) + ", ServerIds=" + String.valueOf(this.theServerIds) + "]";
    }
}

