/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.topics;

import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.command.commands.control.topics.InternalNotificationEvent;
import com.pushtechnology.diffusion.command.commands.control.topics.TopicNotificationEvent;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ConversationIdSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.Serialiser;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
abstract class AbstractTopicNotificationEventSerialiser
extends AbstractSerialiser<TopicNotificationEvent> {
    private final ConversationIdSerialiser conversationIdSerialiser;
    private final Serialiser<TopicSpecification> topicSpecificationSerialiser;

    AbstractTopicNotificationEventSerialiser(ConversationIdSerialiser conversationIdSerialiser, Serialiser<TopicSpecification> topicSpecificationSerialiser) {
        this.conversationIdSerialiser = conversationIdSerialiser;
        this.topicSpecificationSerialiser = topicSpecificationSerialiser;
    }

    @Override
    public final void write(OutputStream out, TopicNotificationEvent value) throws IOException {
        this.conversationIdSerialiser.write(out, value.getCid());
        EncodedDataCodec.writeString(out, value.getTopicPath());
        EncodedDataCodec.writeByte(out, InternalNotificationEvent.TYPE_CONVERTER.toByte(value.getEventType()));
        this.topicSpecificationSerialiser.write(out, value.getTopicSpecification());
    }

    @Override
    protected final TopicNotificationEvent readUnchecked(InputStream in) throws IOException {
        return new TopicNotificationEvent((ConversationId)this.conversationIdSerialiser.read(in), EncodedDataCodec.readString(in), InternalNotificationEvent.TYPE_CONVERTER.fromByte(EncodedDataCodec.readByte(in)), (TopicSpecification)this.topicSpecificationSerialiser.read(in));
    }
}

