/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.command.commands.control.AbstractContextInjectable;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.journal.Journable;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class SubscriptionRequest
extends AbstractContextInjectable
implements Journable {
    private final InternalSessionId sessionId;
    private final String selectorExpression;
    private final String scope;

    public SubscriptionRequest(InternalSessionId sessionId, String selectorExpression, String scope) {
        this(sessionId, selectorExpression, scope, null);
    }

    public SubscriptionRequest(InternalSessionId sessionId, String selectorExpression, String scope, ConversationId cid) {
        super(cid);
        this.sessionId = sessionId;
        this.selectorExpression = selectorExpression;
        this.scope = scope;
    }

    public InternalSessionId getSessionId() {
        return this.sessionId;
    }

    public String getSelectorExpression() {
        return this.selectorExpression;
    }

    public String getScope() {
        return this.scope;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sessionId, this.selectorExpression, this.scope);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubscriptionRequest other = (SubscriptionRequest)o;
        return this.sessionId.equals(other.sessionId) && this.selectorExpression.equals(other.selectorExpression) && this.scope.equals(other.scope);
    }

    public String toString() {
        return String.format("%s[%s, %s, %s]", this.getClass().getSimpleName(), this.sessionId, this.selectorExpression, this.scope);
    }

    @Override
    public Map<String, Object> getJournableContext() {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>(3);
        context.put("session", this.sessionId);
        context.put("selector", this.selectorExpression);
        context.put("scope", this.scope);
        return context;
    }
}

