/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class SetSessionPropertiesResult {
    private final Map<String, String> changedProperties;
    private final List<String> addedProperties;

    private SetSessionPropertiesResult(Map<String, String> properties, List<String> addedProperties) {
        this.changedProperties = properties;
        this.addedProperties = addedProperties;
    }

    public static SetSessionPropertiesResult createResult(Map<String, String> properties, List<String> addedProperties) {
        return new SetSessionPropertiesResult(Collections.unmodifiableMap(properties), addedProperties);
    }

    public Map<String, String> getChangedProperties() {
        return this.changedProperties;
    }

    public List<String> getAddedProperties() {
        return this.addedProperties;
    }

    public Map<String, String> getAllProperties() {
        HashMap<String, String> result = new HashMap<String, String>(this.changedProperties);
        for (String s : this.addedProperties) {
            result.put(s, null);
        }
        return result;
    }

    public int hashCode() {
        int result = this.changedProperties.hashCode();
        result = 31 * result + this.addedProperties.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetSessionPropertiesResult other = (SetSessionPropertiesResult)o;
        return this.changedProperties.equals(other.changedProperties) && this.addedProperties.equals(other.addedProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getSimpleName()).append(" : ");
        sb.append(this.changedProperties).append(':');
        sb.append(this.addedProperties);
        return sb.toString();
    }
}

