/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.client.features.control.clients.ClientControl;
import com.pushtechnology.diffusion.command.commands.control.AbstractContextInjectable;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class SessionPropertiesEvent
extends AbstractContextInjectable
implements ClientControl.SessionEventStream.Event {
    private final InternalSessionId theSessionId;
    private final Type theType;
    private final ClientControl.SessionPropertiesStream.EventType theUpdateType;
    private final Map<String, String> theOldProperties;
    private final Map<String, String> theNewProperties;
    private final ClientControl.CloseReason theCloseReason;

    public static SessionPropertiesEvent createOpenEvent(InternalSessionId sessionId, Map<String, String> properties) {
        return SessionPropertiesEvent.createOpenEvent(null, sessionId, properties);
    }

    static SessionPropertiesEvent createOpenEvent(ConversationId cid, InternalSessionId sessionId, Map<String, String> properties) {
        return new SessionPropertiesEvent(cid, Type.OPEN, null, sessionId, null, Collections.unmodifiableMap(properties), null);
    }

    public static SessionPropertiesEvent createUpdateEvent(InternalSessionId sessionId, ClientControl.SessionPropertiesStream.EventType updateType, Map<String, String> oldProperties, Map<String, String> newProperties) {
        return SessionPropertiesEvent.createUpdateEvent(null, sessionId, updateType, oldProperties, newProperties);
    }

    static SessionPropertiesEvent createUpdateEvent(ConversationId cid, InternalSessionId sessionId, ClientControl.SessionPropertiesStream.EventType updateType, Map<String, String> oldProperties, Map<String, String> newProperties) {
        return new SessionPropertiesEvent(cid, Type.UPDATE, updateType, sessionId, Collections.unmodifiableMap(oldProperties), Collections.unmodifiableMap(newProperties), null);
    }

    public static SessionPropertiesEvent createCloseEvent(InternalSessionId sessionId, ClientControl.CloseReason closeReason, Map<String, String> properties) {
        return SessionPropertiesEvent.createCloseEvent(null, sessionId, closeReason, properties);
    }

    static SessionPropertiesEvent createCloseEvent(ConversationId cid, InternalSessionId sessionId, ClientControl.CloseReason closeReason, Map<String, String> properties) {
        return new SessionPropertiesEvent(cid, Type.CLOSE, null, sessionId, Collections.unmodifiableMap(properties), null, closeReason);
    }

    private SessionPropertiesEvent(ConversationId conversationId, Type type, ClientControl.SessionPropertiesStream.EventType updateType, InternalSessionId sessionId, Map<String, String> oldProperties, Map<String, String> newProperties, ClientControl.CloseReason closeReason) {
        super(conversationId);
        this.theType = type;
        this.theUpdateType = updateType;
        this.theSessionId = sessionId;
        this.theOldProperties = oldProperties;
        this.theNewProperties = newProperties;
        this.theCloseReason = closeReason;
    }

    public Type getType() {
        return this.theType;
    }

    public ClientControl.SessionPropertiesStream.EventType getUpdateType() {
        return this.theUpdateType;
    }

    public Map<String, String> getOldProperties() {
        return this.theOldProperties;
    }

    public Map<String, String> getNewProperties() {
        return this.theNewProperties;
    }

    @Override
    public InternalSessionId sessionId() {
        return this.theSessionId;
    }

    @Override
    public ClientControl.SessionEventStream.Event.Type type() {
        return this.theUpdateType == ClientControl.SessionPropertiesStream.EventType.UPDATED ? ClientControl.SessionEventStream.Event.Type.PROPERTIES : ClientControl.SessionEventStream.Event.Type.STATE;
    }

    @Override
    public ClientControl.SessionEventStream.Event.State state() {
        switch (this.theType) {
            case CLOSE: {
                return ClientControl.SessionEventStream.Event.State.CLOSED;
            }
            case OPEN: {
                return ClientControl.SessionEventStream.Event.State.ACTIVE;
            }
        }
        switch (this.theUpdateType) {
            case DISCONNECTED: {
                return ClientControl.SessionEventStream.Event.State.DISCONNECTED;
            }
            case FAILED_OVER: {
                return ClientControl.SessionEventStream.Event.State.FAILED_OVER;
            }
            case RECONNECTED: {
                return ClientControl.SessionEventStream.Event.State.RECONNECTED;
            }
        }
        return ClientControl.SessionEventStream.Event.State.ACTIVE;
    }

    @Override
    public boolean isOpenEvent() {
        return this.type() == ClientControl.SessionEventStream.Event.Type.STATE && this.state() == ClientControl.SessionEventStream.Event.State.ACTIVE;
    }

    @Override
    public Map<String, String> properties() {
        return this.theType == Type.CLOSE ? this.theOldProperties : this.theNewProperties;
    }

    @Override
    public Map<String, String> changedProperties() {
        return this.theType == Type.UPDATE ? this.theOldProperties : Collections.emptyMap();
    }

    @Override
    public ClientControl.CloseReason closeReason() {
        return this.theCloseReason;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.theType.hashCode();
        result = 31 * result + this.theSessionId.hashCode();
        if (this.theOldProperties != null) {
            result = 31 * result + this.theOldProperties.hashCode();
        }
        if (this.theNewProperties != null) {
            result = 31 * result + this.theNewProperties.hashCode();
        }
        if (this.theCloseReason != null) {
            result = 31 * result + this.theCloseReason.hashCode();
        }
        if (this.theUpdateType != null) {
            result = 31 * result + this.theUpdateType.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SessionPropertiesEvent other = (SessionPropertiesEvent)obj;
        return this.theType == other.theType && this.theSessionId.equals(other.theSessionId) && Objects.equals(this.theOldProperties, other.theOldProperties) && Objects.equals(this.theNewProperties, other.theNewProperties) && Objects.equals((Object)this.theCloseReason, (Object)other.theCloseReason) && Objects.equals((Object)this.theUpdateType, (Object)other.theUpdateType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("Event: ").append((Object)this.theType).append('(').append(this.theSessionId).append(',');
        switch (this.theType) {
            case CLOSE: {
                sb.append(this.theOldProperties).append(',').append((Object)this.theCloseReason);
                break;
            }
            case OPEN: {
                sb.append(this.theNewProperties);
                break;
            }
            case UPDATE: {
                sb.append((Object)this.theUpdateType).append(',').append(this.theOldProperties).append(',').append(this.theNewProperties);
                break;
            }
        }
        ConversationId cid = this.getContextUnchecked();
        if (cid != null) {
            sb.append(',').append(cid);
        }
        sb.append(')');
        return sb.toString();
    }

    public static enum Type {
        OPEN,
        UPDATE,
        CLOSE;

    }
}

