/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.control.client.SessionEventListenerRegistrationRequest;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ConversationIdSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.common.BooleanSerialiser;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

@CommandSerialiser(spec="protocol28-session-event-listener-registration-request", valueType=SessionEventListenerRegistrationRequest.class)
public final class Protocol28SessionEventListenerRegistrationRequestSerialiser
extends AbstractSerialiser<SessionEventListenerRegistrationRequest> {
    private final BooleanSerialiser theBooleanSerialiser;
    private final ConversationIdSerialiser theConversationIdSerialiser;

    public Protocol28SessionEventListenerRegistrationRequestSerialiser(BooleanSerialiser booleanSerialiser, ConversationIdSerialiser conversationIdSerialiser) {
        this.theBooleanSerialiser = booleanSerialiser;
        this.theConversationIdSerialiser = conversationIdSerialiser;
    }

    @Override
    public void write(OutputStream out, SessionEventListenerRegistrationRequest request) throws IOException {
        this.theBooleanSerialiser.write(out, request.isClusterAware());
        String sessionFilter = request.getSessionFilter();
        if (sessionFilter == null) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            EncodedDataCodec.writeString(out, sessionFilter);
        }
        Set<String> requestedProperties = request.getRequestedProperties();
        if (requestedProperties == null) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            Protocol28SessionEventListenerRegistrationRequestSerialiser.writeStrings(out, requestedProperties);
        }
        long sessionStartTime = request.getSessionStartTime();
        if (sessionStartTime == 0L) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            EncodedDataCodec.writeInt64(out, sessionStartTime);
        }
        this.theConversationIdSerialiser.write(out, request.getConversationID());
    }

    @Override
    protected SessionEventListenerRegistrationRequest readUnchecked(InputStream in) throws IOException {
        long sessionStartTime;
        HashSet<String> sessionProperties;
        String sessionFilter;
        boolean clusterAware = (Boolean)this.theBooleanSerialiser.read(in);
        byte hasSessionFilter = EncodedDataCodec.readByte(in);
        if (hasSessionFilter == 0) {
            sessionFilter = null;
        } else if (hasSessionFilter == 1) {
            sessionFilter = EncodedDataCodec.readString(in);
        } else {
            throw new IOException("Invalid session filter option byte " + hasSessionFilter);
        }
        byte sessionPropertiesOption = EncodedDataCodec.readByte(in);
        if (sessionPropertiesOption == 0) {
            sessionProperties = null;
        } else if (sessionPropertiesOption == 1) {
            sessionProperties = new HashSet<String>(Protocol28SessionEventListenerRegistrationRequestSerialiser.readStrings(in));
        } else {
            throw new IOException("Invalid session properties option byte " + sessionPropertiesOption);
        }
        byte sessionStartTimeOption = EncodedDataCodec.readByte(in);
        if (sessionStartTimeOption == 0) {
            sessionStartTime = 0L;
        } else if (sessionStartTimeOption == 1) {
            sessionStartTime = EncodedDataCodec.readInt64(in);
        } else {
            throw new IOException("Invalid session start time option byte " + sessionStartTimeOption);
        }
        return new SessionEventListenerRegistrationRequest(clusterAware, sessionFilter, sessionProperties, sessionStartTime, (ConversationId)this.theConversationIdSerialiser.read(in));
    }
}

