/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.client.features.control.clients.ClientControl;
import com.pushtechnology.diffusion.command.commands.control.client.SessionPropertiesEvent;
import com.pushtechnology.diffusion.command.commands.control.client.SessionPropertiesEventSerialiser;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ConversationIdSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import com.pushtechnology.diffusion.session.impl.SessionIdSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Protocol16SessionPropertiesEventSerialiser
extends SessionPropertiesEventSerialiser {
    private static final byte NEW = 1;
    private static final byte CHANGE = 2;
    private static final byte REMOVE = 3;
    private static final byte SAME = 4;

    public Protocol16SessionPropertiesEventSerialiser(SessionIdSerialiser sessionIdSerialiser, ConversationIdSerialiser conversationIdSerialiser) {
        super(sessionIdSerialiser, conversationIdSerialiser);
    }

    Protocol16SessionPropertiesEventSerialiser(SessionIdSerialiser sessionIdSerialiser) {
        super(sessionIdSerialiser, null);
    }

    @Override
    protected void writeUpdateMaps(OutputStream out, Map<String, String> oldProperties, Map<String, String> newProperties) throws IOException {
        String key;
        HashSet<String> removals = new HashSet<String>();
        for (Map.Entry<String, String> entry : oldProperties.entrySet()) {
            key = entry.getKey();
            if (newProperties.containsKey(key)) continue;
            removals.add(key);
        }
        EncodedDataCodec.writeInt32(out, newProperties.size() + removals.size());
        for (String key2 : removals) {
            EncodedDataCodec.writeString(out, key2);
            EncodedDataCodec.writeByte(out, (byte)3);
            EncodedDataCodec.writeString(out, oldProperties.get(key2));
        }
        for (Map.Entry<String, String> entry : newProperties.entrySet()) {
            key = entry.getKey();
            String newValue = entry.getValue();
            EncodedDataCodec.writeString(out, key);
            if (oldProperties.containsKey(key)) {
                String oldValue = oldProperties.get(key);
                if (oldValue == null) {
                    EncodedDataCodec.writeByte(out, (byte)1);
                    EncodedDataCodec.writeString(out, newValue);
                    continue;
                }
                EncodedDataCodec.writeByte(out, (byte)2);
                EncodedDataCodec.writeString(out, oldValue);
                EncodedDataCodec.writeString(out, newValue);
                continue;
            }
            EncodedDataCodec.writeByte(out, (byte)4);
            EncodedDataCodec.writeString(out, newValue);
        }
    }

    @Override
    protected SessionPropertiesEvent completeReadUpdateEvent(InputStream in, ConversationId conversationId, InternalSessionId sessionId, ClientControl.SessionPropertiesStream.EventType eventType) throws IOException {
        HashMap<String, String> oldProperties = new HashMap<String, String>();
        HashMap<String, String> newProperties = new HashMap<String, String>();
        int size = EncodedDataCodec.readInt32(in);
        block6: for (int i = 0; i < size; ++i) {
            String key = EncodedDataCodec.readString(in);
            byte type = EncodedDataCodec.readByte(in);
            switch (type) {
                case 1: {
                    oldProperties.put(key, null);
                    newProperties.put(key, EncodedDataCodec.readString(in));
                    continue block6;
                }
                case 2: {
                    oldProperties.put(key, EncodedDataCodec.readString(in));
                    newProperties.put(key, EncodedDataCodec.readString(in));
                    continue block6;
                }
                case 3: {
                    oldProperties.put(key, EncodedDataCodec.readString(in));
                    continue block6;
                }
                case 4: {
                    newProperties.put(key, EncodedDataCodec.readString(in));
                    continue block6;
                }
                default: {
                    throw new IOException("Invalid update entry type : " + type);
                }
            }
        }
        return SessionPropertiesEvent.createUpdateEvent(conversationId, sessionId, eventType, oldProperties, newProperties);
    }
}

