/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.control.client.MessagingClientSendRequest;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.TrailingBytesWriteSerialiser;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import com.pushtechnology.diffusion.session.impl.SessionIdSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="messaging-client-send-request", valueType=MessagingClientSendRequest.class)
public final class MessagingClientSendRequestSerialiser
extends AbstractSerialiser<MessagingClientSendRequest>
implements TrailingBytesWriteSerialiser<MessagingClientSendRequest> {
    private final SessionIdSerialiser sessionSerialiser;
    private final DataTypes dataTypes;

    public MessagingClientSendRequestSerialiser(SessionIdSerialiser sessionSerialiser, DataTypes dataTypes) {
        this.sessionSerialiser = sessionSerialiser;
        this.dataTypes = dataTypes;
    }

    @Override
    public MessagingClientSendRequest readUnchecked(InputStream in) throws IOException {
        InternalSessionId session = (InternalSessionId)this.sessionSerialiser.read(in);
        String path = EncodedDataCodec.readString(in);
        DataType<?> requestDataType = this.dataTypes.getByName(EncodedDataCodec.readString(in));
        IBytes request = IBytes.toIBytes(EncodedDataCodec.readByteArray(in));
        return new MessagingClientSendRequest(session, path, requestDataType, request);
    }

    @Override
    public void writeHead(OutputStream out, MessagingClientSendRequest request) throws IOException {
        this.sessionSerialiser.write(out, request.getSessionId());
        EncodedDataCodec.writeString(out, request.getPath());
        EncodedDataCodec.writeString(out, request.getRequestDataType().getTypeName());
    }

    @Override
    public IBytes getTail(MessagingClientSendRequest request) {
        return request.getRequest();
    }
}

