/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.client.features.NoSuchSessionException;
import java.util.Collections;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class GetSessionPropertiesResult {
    public static final GetSessionPropertiesResult NO_SUCH_SESSION = new GetSessionPropertiesResult(Collections.emptyMap());
    private final Map<String, String> theProperties;

    public static GetSessionPropertiesResult createResult(Map<String, String> properties) {
        return new GetSessionPropertiesResult(Collections.unmodifiableMap(properties));
    }

    private GetSessionPropertiesResult(Map<String, String> properties) {
        this.theProperties = properties;
    }

    public Map<String, String> getProperties() {
        return this.theProperties;
    }

    public Map<String, String> getPropertiesChecked() {
        if (this == NO_SUCH_SESSION) {
            throw new NoSuchSessionException("The client session does not exist.");
        }
        return this.theProperties;
    }

    public int hashCode() {
        return this.theProperties.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetSessionPropertiesResult other = (GetSessionPropertiesResult)obj;
        if (this == NO_SUCH_SESSION) {
            return other == NO_SUCH_SESSION;
        }
        if (other == NO_SUCH_SESSION) {
            return false;
        }
        return this.theProperties.equals(other.theProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getSimpleName()).append(" : ");
        if (this == NO_SUCH_SESSION) {
            sb.append("No Session");
        } else {
            sb.append(this.theProperties.toString());
        }
        return sb.toString();
    }
}

