/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.control.client.FilterResponse;
import com.pushtechnology.diffusion.command.commands.control.client.MessagingResponse;
import com.pushtechnology.diffusion.command.commands.control.client.MessagingResponseSerialiser;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ConversationIdSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import com.pushtechnology.diffusion.session.impl.SessionIdSerialiser;
import com.pushtechnology.diffusion.types.ErrorReasonSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="filter-response", valueType=FilterResponse.class)
public class FilterResponseSerialiser
extends AbstractSerialiser<FilterResponse> {
    private final ConversationIdSerialiser conversationSerialiser;
    private final SessionIdSerialiser sessionIdSerialiser;
    private final MessagingResponseSerialiser messagingResponseSerialiser;
    private final ErrorReasonSerialiser errorReasonSerialiser;

    public FilterResponseSerialiser(ConversationIdSerialiser conversationSerialiser, SessionIdSerialiser sessionIdSerialiser, MessagingResponseSerialiser messagingResponseSerialiser, ErrorReasonSerialiser errorReasonSerialiser) {
        this.conversationSerialiser = conversationSerialiser;
        this.sessionIdSerialiser = sessionIdSerialiser;
        this.messagingResponseSerialiser = messagingResponseSerialiser;
        this.errorReasonSerialiser = errorReasonSerialiser;
    }

    @Override
    public FilterResponse readUnchecked(InputStream in) throws IOException {
        ConversationId cid = (ConversationId)this.conversationSerialiser.read(in);
        InternalSessionId sessionId = (InternalSessionId)this.sessionIdSerialiser.read(in);
        switch (EncodedDataCodec.readByte(in)) {
            case 0: {
                MessagingResponse messagingResponse = (MessagingResponse)this.messagingResponseSerialiser.read(in);
                return new FilterResponse(cid, sessionId, messagingResponse);
            }
        }
        ErrorReason errorReason = (ErrorReason)this.errorReasonSerialiser.read(in);
        return new FilterResponse(cid, sessionId, errorReason);
    }

    @Override
    public void write(OutputStream out, FilterResponse response) throws IOException {
        this.conversationSerialiser.write(out, response.getContext());
        this.sessionIdSerialiser.write(out, response.getSessionId());
        if (response.getResponse() != null) {
            EncodedDataCodec.writeByte(out, (byte)0);
            this.messagingResponseSerialiser.write(out, response.getResponse());
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            this.errorReasonSerialiser.write(out, response.getErrorReason());
        }
    }
}

