/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.command.commands.control.client.MessagingResponse;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import net.jcip.annotations.Immutable;

@Immutable
public class FilterResponse {
    private final ConversationId cid;
    private final InternalSessionId sessionId;
    private final MessagingResponse response;
    private final ErrorReason errorReason;

    public FilterResponse(ConversationId cid, InternalSessionId sessionId, MessagingResponse messagingResponse) {
        this(cid, sessionId, messagingResponse, null);
    }

    public FilterResponse(ConversationId cid, InternalSessionId sessionId, ErrorReason errorReason) {
        this(cid, sessionId, null, errorReason);
    }

    private FilterResponse(ConversationId cid, InternalSessionId sessionId, MessagingResponse response, ErrorReason errorReason) {
        this.cid = cid;
        this.sessionId = sessionId;
        this.response = response;
        this.errorReason = errorReason;
    }

    public ConversationId getContext() {
        return this.cid;
    }

    public InternalSessionId getSessionId() {
        return this.sessionId;
    }

    public MessagingResponse getResponse() {
        return this.response;
    }

    public FilterResponse withContext(ConversationId id) {
        return new FilterResponse(id, this.sessionId, this.response, this.errorReason);
    }

    public ErrorReason getErrorReason() {
        return this.errorReason;
    }

    public int hashCode() {
        int result = this.cid.hashCode();
        result = 31 * result + this.sessionId.hashCode();
        if (this.response != null) {
            result = 31 * result + this.response.hashCode();
        }
        if (this.errorReason != null) {
            result = 31 * result + this.errorReason.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterResponse)) {
            return false;
        }
        FilterResponse other = (FilterResponse)o;
        return this.cid.equals(other.cid) && this.sessionId.equals(other.sessionId) && this.equalsMessagingResponse(other) && this.equalsErrorReason(other);
    }

    private boolean equalsMessagingResponse(FilterResponse other) {
        if (this.response == null) {
            return other.response == null;
        }
        return this.response.equals(other.response);
    }

    private boolean equalsErrorReason(FilterResponse other) {
        if (this.errorReason == null) {
            return other.errorReason == null;
        }
        return this.errorReason.equals(other.errorReason);
    }

    public String toString() {
        return String.format("%s[%s, %s, %s, %s]", this.getClass().getSimpleName(), this.cid, this.sessionId, this.response, this.errorReason);
    }
}

