/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.client.features.InvalidFilterException;
import com.pushtechnology.diffusion.client.types.ErrorReport;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@Immutable
public final class CountOrParserErrors {
    private final int count;
    private final List<ErrorReport> errors;

    public CountOrParserErrors(int count) {
        this(count, Collections.emptyList());
    }

    public CountOrParserErrors(List<ErrorReport> errors) {
        this(0, errors);
    }

    CountOrParserErrors(int numberSent, List<ErrorReport> errors) {
        this.count = numberSent;
        this.errors = errors;
    }

    public int getCount() {
        return this.count;
    }

    public int getCountChecked() {
        if (!this.errors.isEmpty()) {
            throw new InvalidFilterException("Invalid filter", this.errors);
        }
        return this.count;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<ErrorReport> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.count, this.errors);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountOrParserErrors other = (CountOrParserErrors)o;
        return this.count == other.count && this.errors.equals(other.errors);
    }

    public String toString() {
        return String.format("%s[%s , %s]", this.getClass().getSimpleName(), this.count, this.errors);
    }
}

