/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.authentication;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.control.authentication.AuthenticatorResponse;
import com.pushtechnology.diffusion.command.commands.control.authentication.AuthenticatorResponseSerialiser;
import com.pushtechnology.diffusion.command.commands.control.authentication.PeerAuthenticatorResponse;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@CommandSerialiser(spec="peer-authenticator-response", valueType=PeerAuthenticatorResponse.class)
public final class PeerAuthenticatorResponseSerialiser
extends AbstractSerialiser<PeerAuthenticatorResponse> {
    private final AuthenticatorResponseSerialiser theResponseSerialiser;

    public PeerAuthenticatorResponseSerialiser(AuthenticatorResponseSerialiser responseSerialiser) {
        this.theResponseSerialiser = responseSerialiser;
    }

    @Override
    public void write(OutputStream out, PeerAuthenticatorResponse response) throws IOException {
        if (response.equals(PeerAuthenticatorResponse.FAIL)) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            this.theResponseSerialiser.write(out, response.getResponse());
        }
    }

    @Override
    protected PeerAuthenticatorResponse readUnchecked(InputStream in) throws IOException {
        byte option = EncodedDataCodec.readByte(in);
        if (option == 1) {
            return new PeerAuthenticatorResponse((AuthenticatorResponse)this.theResponseSerialiser.read(in));
        }
        if (option == 0) {
            return PeerAuthenticatorResponse.FAIL;
        }
        throw new IOException("Invalid option byte " + option);
    }
}

