/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.authentication;

import com.pushtechnology.diffusion.client.security.authentication.Authenticator;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class AuthenticatorResponse {
    public static final AuthenticatorResponse DENY = new AuthenticatorResponse(TypeCode.DENY);
    public static final AuthenticatorResponse ABSTAIN = new AuthenticatorResponse(TypeCode.ABSTAIN);
    private final TypeCode type;
    private final Map<String, String> properties;

    public static AuthenticatorResponse allow(Map<String, String> properties) {
        return new AuthenticatorResponse(TypeCode.ALLOW, properties);
    }

    private AuthenticatorResponse(TypeCode code) {
        this(code, null);
    }

    private AuthenticatorResponse(TypeCode type, Map<String, String> properties) {
        this.type = type;
        this.properties = properties;
    }

    public TypeCode getType() {
        return this.type;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void apply(Authenticator.Callback callback) {
        switch (this.type) {
            case ALLOW: {
                callback.allow(this.properties);
                break;
            }
            case ABSTAIN: {
                callback.abstain();
                break;
            }
            default: {
                callback.deny();
            }
        }
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + (this.properties == null ? 0 : this.properties.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorResponse other = (AuthenticatorResponse)o;
        return this.type == other.type && Objects.equals(this.properties, other.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("AuthenticatorResponse [type=").append((Object)this.type);
        if (this.properties != null) {
            sb.append(", properties=").append(this.properties);
        }
        sb.append(']');
        return sb.toString();
    }

    public static enum TypeCode {
        DENY,
        ABSTAIN,
        ALLOW;

    }
}

