/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.authentication;

import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.client.types.impl.CredentialsSerialiser;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.control.authentication.AuthenticatorRequest;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ConversationIdSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="authenticator-request", valueType=AuthenticatorRequest.class)
public final class AuthenticatorRequestSerialiser
extends AbstractSerialiser<AuthenticatorRequest> {
    private final CredentialsSerialiser credentialsSerialiser;
    private final ConversationIdSerialiser conversationIDSerialiser;

    public AuthenticatorRequestSerialiser(CredentialsSerialiser credentialsSerialiser, ConversationIdSerialiser conversationIDSerialiser) {
        this.credentialsSerialiser = credentialsSerialiser;
        this.conversationIDSerialiser = conversationIDSerialiser;
    }

    @Override
    public AuthenticatorRequest readUnchecked(InputStream input) throws IOException {
        String principal = EncodedDataCodec.readString(input);
        Credentials credentials = (Credentials)this.credentialsSerialiser.read(input);
        Map<String, String> sessionProperties = AuthenticatorRequestSerialiser.readStringMap(input);
        Map<String, String> proposedProperties = AuthenticatorRequestSerialiser.readStringMap(input);
        ConversationId cid = (ConversationId)this.conversationIDSerialiser.read(input);
        return new AuthenticatorRequest(principal, credentials, sessionProperties, proposedProperties, cid);
    }

    @Override
    public void write(OutputStream out, AuthenticatorRequest request) throws IOException {
        EncodedDataCodec.writeString(out, request.getPrincipal());
        this.credentialsSerialiser.write(out, request.getCredentials());
        AuthenticatorRequestSerialiser.writeStringMap(out, request.getSessionProperties());
        AuthenticatorRequestSerialiser.writeStringMap(out, request.getProposedProperties());
        this.conversationIDSerialiser.write(out, request.getContext());
    }
}

