/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.client.v4;

import com.pushtechnology.diffusion.api.internal.connection.ClientType;
import com.pushtechnology.diffusion.api.internal.connection.ConnectionTypeProvider;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.command.sender.ServiceLocator;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.ServiceDefinition;
import com.pushtechnology.diffusion.io.serialisation.SerialisationContext;
import com.pushtechnology.diffusion.io.serialisation.Serialiser;
import com.pushtechnology.diffusion.message.Sender;
import com.pushtechnology.diffusion.v4.services.ServiceReferenceImpl;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
final class V4ServiceLocator
implements ServiceLocator {
    private static final Logger LOG = LoggerFactory.getLogger(V4ServiceLocator.class);
    private final InternalSession session;
    private final SerialisationContext commandSerialisers;
    private final Sender sender;

    V4ServiceLocator(InternalSession session, SerialisationContext commandSerialisers, Sender sender) {
        this.sender = sender;
        this.session = session;
        this.commandSerialisers = commandSerialisers;
    }

    @Override
    public <C, R> ServiceReference<C, R> obtainService(ServiceDefinition<C, R> definition) {
        byte protocolByte;
        ClientType clientType = ConnectionTypeProvider.clientType();
        Serialiser<C> requestSerialiser = definition.requestSerialiserFor(this.commandSerialisers, clientType, protocolByte = this.session.getProtocolVersion().asByte());
        if (requestSerialiser == null) {
            LOG.warn("Session {} attempted to obtain unsupported service {}", (Object)this.session, (Object)definition);
            return UNSUPPORTED_SERVICE;
        }
        Serialiser<R> responseSerialiser = definition.responseSerialiserFor(this.commandSerialisers, clientType, protocolByte);
        ServiceReferenceImpl<C, R, Sender> reference = new ServiceReferenceImpl<C, R, Sender>(definition, requestSerialiser, responseSerialiser, this.session, this.sender);
        LOG.trace("'{}' : Created {}", (Object)this, (Object)reference);
        return reference;
    }

    public String toString() {
        return "ServiceLocator<" + String.valueOf(this.session) + ">";
    }
}

