/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.collections;

import com.pushtechnology.diffusion.utils.unsafe.UnsafeAccess;
import java.util.BitSet;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;

public final class UnsafeBitSetAccess {
    private static final long WORDS_FO;
    private static final long WORDS_IN_USE_FO;

    private UnsafeBitSetAccess() {
    }

    private static long[] getWords(BitSet bs) {
        return (long[])UnsafeAccess.UNSAFE.getObject(bs, WORDS_FO);
    }

    private static int getWordsInUse(BitSet bs) {
        return UnsafeAccess.UNSAFE.getInt(bs, WORDS_IN_USE_FO);
    }

    public static void forEach(BitSet bs, IntConsumer action) {
        int wordsInUse = UnsafeBitSetAccess.getWordsInUse(bs);
        if (UnsafeBitSetAccess.isDense(bs.cardinality(), wordsInUse)) {
            UnsafeBitSetAccess.denseForEach(bs, action);
        } else {
            UnsafeBitSetAccess.internalSparseForEach(wordsInUse, bs, action);
        }
    }

    private static boolean isDense(int cardinality, int wordsInUse) {
        return cardinality >> 6 > wordsInUse - (wordsInUse >> 4);
    }

    public static void denseForEach(BitSet bs, IntConsumer action) {
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            if (i == Integer.MAX_VALUE) {
                action.accept(i);
                return;
            }
            int j = bs.nextClearBit(i + 1);
            for (int k = i; k < j; ++k) {
                action.accept(k);
            }
            if (j == Integer.MAX_VALUE) {
                return;
            }
            i = bs.nextSetBit(j + 1);
        }
    }

    public static void sparseForEach(BitSet bs, IntConsumer action) {
        UnsafeBitSetAccess.internalSparseForEach(UnsafeBitSetAccess.getWordsInUse(bs), bs, action);
    }

    private static void internalSparseForEach(int wordsInUse, BitSet bs, IntConsumer action) {
        long[] words = UnsafeBitSetAccess.getWords(bs);
        for (int i = 0; i < wordsInUse; ++i) {
            long w = words[i];
            int offset = i << 6;
            if (w == -1L) {
                UnsafeBitSetAccess.forLong(offset, action);
                continue;
            }
            UnsafeBitSetAccess.wordForEach(offset, w, action);
        }
    }

    private static void forLong(int start, IntConsumer action) {
        for (int i = start; i < start + 64; ++i) {
            action.accept(i);
        }
    }

    private static void wordForEach(int offset, long word, IntConsumer action) {
        int lastBit;
        for (long w = word; w != 0L; w &= -2L << lastBit) {
            lastBit = Long.numberOfTrailingZeros(w);
            action.accept(offset + lastBit);
        }
    }

    public static int count(BitSet bs, IntPredicate predicate) {
        int wordsInUse = UnsafeBitSetAccess.getWordsInUse(bs);
        if (UnsafeBitSetAccess.isDense(bs.cardinality(), wordsInUse)) {
            return UnsafeBitSetAccess.denseCount(bs, predicate);
        }
        return UnsafeBitSetAccess.internalSparseCount(wordsInUse, bs, predicate);
    }

    static int denseCount(BitSet bs, IntPredicate action) {
        int i = bs.nextSetBit(0);
        int result = 0;
        while (i >= 0) {
            if (i == Integer.MAX_VALUE) {
                return result += action.test(i) ? 1 : 0;
            }
            int j = bs.nextClearBit(i + 1);
            for (int k = i; k < j; ++k) {
                result += action.test(k) ? 1 : 0;
            }
            if (j == Integer.MAX_VALUE) break;
            i = bs.nextSetBit(j + 1);
        }
        return result;
    }

    static int sparseCount(BitSet bs, IntPredicate predicate) {
        return UnsafeBitSetAccess.internalSparseCount(UnsafeBitSetAccess.getWordsInUse(bs), bs, predicate);
    }

    private static int internalSparseCount(int wordsInUse, BitSet bs, IntPredicate predicate) {
        long[] words = UnsafeBitSetAccess.getWords(bs);
        int result = 0;
        for (int i = 0; i < wordsInUse; ++i) {
            long w = words[i];
            int offset = i << 6;
            if (w == -1L) {
                result += UnsafeBitSetAccess.countLong(offset, predicate);
                continue;
            }
            result += UnsafeBitSetAccess.countWord(offset, w, predicate);
        }
        return result;
    }

    private static int countLong(int start, IntPredicate predicate) {
        int result = 0;
        for (int i = start; i < start + 64; ++i) {
            result += predicate.test(i) ? 1 : 0;
        }
        return result;
    }

    private static int countWord(int offset, long word, IntPredicate predicate) {
        int lastBit;
        int result = 0;
        for (long w = word; w != 0L; w &= -2L << lastBit) {
            lastBit = Long.numberOfTrailingZeros(w);
            result += predicate.test(offset + lastBit) ? 1 : 0;
        }
        return result;
    }

    static {
        try {
            WORDS_FO = UnsafeAccess.UNSAFE.objectFieldOffset(BitSet.class.getDeclaredField("words"));
            WORDS_IN_USE_FO = UnsafeAccess.UNSAFE.objectFieldOffset(BitSet.class.getDeclaredField("wordsInUse"));
        }
        catch (NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

