/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.collections;

import com.pushtechnology.diffusion.collections.ImmutableSet;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ImmutableSortedSet<V>
extends ImmutableSet<V>
implements SortedSet<V> {
    private static final long serialVersionUID = -3298810119747018748L;
    private static final ImmutableSortedSet<Object> EMPTY = new Empty();

    public static <V> ImmutableSortedSet<V> empty() {
        return EMPTY;
    }

    @SafeVarargs
    public static <V> ImmutableSortedSet<V> of(V ... a) {
        int l = a.length;
        if (l == 0) {
            return ImmutableSortedSet.empty();
        }
        if (l == 1) {
            return new ImmutableSortedSet<V>(a);
        }
        HashSet<V> unique = new HashSet<V>(l);
        for (V v : a) {
            unique.add(v);
        }
        return new ImmutableSortedSet(ImmutableSortedSet.toSortedArray(unique));
    }

    public static <V> ImmutableSortedSet<V> from(Set<? extends V> vs) {
        if (vs.isEmpty()) {
            return ImmutableSortedSet.empty();
        }
        if (vs instanceof ImmutableSortedSet) {
            ImmutableSortedSet vss = (ImmutableSortedSet)vs;
            return vss;
        }
        return new ImmutableSortedSet<V>(ImmutableSortedSet.toSortedArray(vs));
    }

    public static <V> ImmutableSortedSet<V> from(Collection<? extends V> vs) {
        int l = vs.size();
        if (l == 0) {
            return ImmutableSortedSet.empty();
        }
        if (l == 1) {
            return new ImmutableSortedSet<V>(ImmutableSortedSet.collectionToArray(vs));
        }
        return new ImmutableSortedSet<V>(ImmutableSortedSet.toSortedArray(new HashSet<V>(vs)));
    }

    private static <V> V[] toSortedArray(Set<? extends V> vs) {
        Object[] a = ImmutableSortedSet.collectionToArray(vs);
        Arrays.sort(a);
        return a;
    }

    private ImmutableSortedSet(V[] sorted) {
        super(sorted);
    }

    @Override
    public boolean contains(Object o) {
        return Arrays.binarySearch(this.array(), o) >= 0;
    }

    @Override
    public final ImmutableSortedSet<V> with(V v) {
        Object[] array = this.array();
        int bs = Arrays.binarySearch(array, v);
        if (bs >= 0) {
            return this;
        }
        int i = -bs - 1;
        Object[] a = Arrays.copyOf(array, array.length + 1);
        System.arraycopy(array, i, a, i + 1, a.length - i - 1);
        a[i] = v;
        return new ImmutableSortedSet<Object>(a);
    }

    @Override
    public final ImmutableSortedSet<V> without(V v) {
        Object[] array = this.array();
        int bs = Arrays.binarySearch(array, v);
        if (bs < 0) {
            return this;
        }
        return new ImmutableSortedSet<Object>(ImmutableSortedSet.arrayWithout(array, bs));
    }

    @Override
    public final ImmutableSortedSet<V> withoutFirst(Predicate<? super V> predicate) {
        V[] a = this.arrayWithoutFirst(predicate);
        return a == this.array() ? this : new ImmutableSortedSet<V>(a);
    }

    @Override
    public final ImmutableSortedSet<V> without(Predicate<? super V> predicate) {
        V[] a = this.arrayWithout(predicate);
        return a == this.array() ? this : new ImmutableSortedSet<V>(a);
    }

    @Override
    public final ImmutableSortedSet<V> withAll(Collection<? extends V> vs) {
        if (this.containsAll(vs)) {
            return this;
        }
        HashSet<V> temporary = new HashSet<V>(this.size() + vs.size());
        temporary.addAll(this);
        temporary.addAll(vs);
        return new ImmutableSortedSet(ImmutableSortedSet.toSortedArray(temporary));
    }

    @Override
    public final Comparator<? super V> comparator() {
        return null;
    }

    @Override
    public final SortedSet<V> subSet(V fromElement, V toElement) {
        int end;
        Object[] a = this.array();
        int bs = Arrays.binarySearch(a, fromElement);
        int start = bs >= 0 ? bs : -bs - 1;
        int bs2 = Arrays.binarySearch(a, toElement);
        int n = end = bs2 >= 0 ? bs2 : -bs2 - 1;
        if (start == end) {
            return ImmutableSortedSet.empty();
        }
        if (start == 0 && end == a.length) {
            return this;
        }
        Object[] subset = (Object[])Array.newInstance(a.getClass().getComponentType(), end - start);
        System.arraycopy(a, start, subset, 0, subset.length);
        return new ImmutableSortedSet<Object>(subset);
    }

    @Override
    public final ImmutableSortedSet<V> headSet(V toElement) {
        int i;
        Object[] a = this.array();
        int bs = Arrays.binarySearch(a, toElement);
        int n = i = bs >= 0 ? bs : -bs - 1;
        if (i == 0) {
            return ImmutableSortedSet.empty();
        }
        if (i == a.length) {
            return this;
        }
        return new ImmutableSortedSet<Object>(Arrays.copyOf(a, i));
    }

    @Override
    public final SortedSet<V> tailSet(V fromElement) {
        int i;
        Object[] a = this.array();
        int bs = Arrays.binarySearch(a, fromElement);
        int n = i = bs >= 0 ? bs : -bs - 1;
        if (i == a.length) {
            return ImmutableSortedSet.empty();
        }
        if (i == 0) {
            return this;
        }
        Object[] tail = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length - i);
        System.arraycopy(a, i, tail, 0, tail.length);
        return new ImmutableSortedSet<Object>(tail);
    }

    @Override
    public final V first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.array()[0];
    }

    @Override
    public final V last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        V[] a = this.array();
        return a[a.length - 1];
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof ImmutableSortedSet) {
            V[] a = this.array();
            int i = 0;
            for (Object other : c) {
                Object v;
                do {
                    if (i == a.length) {
                        return false;
                    }
                    v = a[i];
                    ++i;
                } while (!other.equals(v));
            }
            return true;
        }
        return super.containsAll(c);
    }

    @Override
    public final boolean equals(Object other) {
        if (other instanceof ImmutableSortedSet) {
            return Arrays.equals(this.array(), ((ImmutableSortedSet)other).array());
        }
        return super.equals(other);
    }

    private static final class Empty
    extends ImmutableSortedSet<Object> {
        private static final long serialVersionUID = -211973730908994093L;

        private Empty() {
            super(new Object[0]);
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void forEach(Consumer<Object> action) {
            Objects.requireNonNull(action);
        }

        @Override
        public boolean removeIf(Predicate<Object> filter) {
            Objects.requireNonNull(filter);
            return false;
        }

        @Override
        public Spliterator<Object> spliterator() {
            return Spliterators.emptySpliterator();
        }
    }
}

