/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.clients.token.impl;

import com.pushtechnology.diffusion.clients.token.SessionToken;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import java.util.Arrays;
import net.jcip.annotations.Immutable;

@Immutable
public final class SessionTokenImpl
implements SessionToken {
    private final byte[] external;

    public static SessionToken fromExternalString(String externalString) {
        byte[] external = CharsetUtils.stringToASCII(externalString);
        return new SessionTokenImpl(external);
    }

    public SessionTokenImpl(byte[] external) {
        this.external = external;
    }

    @Override
    public IBytes toBytes() {
        return IBytes.toIBytes(this.external);
    }

    public int hashCode() {
        return Arrays.hashCode(this.external);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionTokenImpl other = (SessionTokenImpl)o;
        return Arrays.equals(this.external, other.external);
    }

    public String toString() {
        return CharsetUtils.asciiToString(this.external);
    }

    @Override
    public int compareTo(SessionToken o) {
        if (o == this) {
            return 0;
        }
        SessionTokenImpl other = (SessionTokenImpl)o;
        byte[] thisArray = this.external;
        byte[] thatArray = other.external;
        if (thisArray.length < thatArray.length) {
            return -1;
        }
        if (thisArray.length > thatArray.length) {
            return 1;
        }
        for (int i = 0; i < thisArray.length; ++i) {
            int c = Byte.compare(thisArray[i], thatArray[i]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }
}

