/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.topics.impl;

import com.pushtechnology.diffusion.client.features.TimeSeries;
import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.client.topics.impl.FetchRequestImpl;
import com.pushtechnology.diffusion.command.commands.fetch.FetchQueryResult;
import com.pushtechnology.diffusion.command.commands.fetch.FetchTopicResult;
import com.pushtechnology.diffusion.command.commands.fetch.FetchTopicSizeInfo;
import com.pushtechnology.diffusion.datatype.Bytes;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.datatype.impl.TopicTypeToDataType;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.topics.details.TopicSpecificationImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
final class FetchResultImpl<V>
implements Topics.FetchResult<V> {
    private final List<Topics.FetchResult.TopicResult<V>> results;
    private final boolean hasMore;

    static <V> Topics.FetchResult<V> create(Class<? extends V> valueClass, FetchQueryResult result, TopicTypeToDataType topicTypeToDataType, DataTypes dataTypes) {
        List<Map<String, String>> properties = result.properties();
        ArrayList<TopicResultImpl<TimeSeries.Event>> resultList = new ArrayList<TopicResultImpl<TimeSeries.Event>>();
        for (FetchTopicResult topicResult : result.results()) {
            TimeSeries.Event value;
            TopicType type = topicResult.type();
            IBytes bytesValue = topicResult.value();
            if (bytesValue == null) {
                value = null;
            } else if (type == TopicType.TIME_SERIES) {
                TimeSeries.Event e = (TimeSeries.Event)FetchRequestImpl.TIME_SERIES_DATA_TYPE.readValue(bytesValue);
                value = valueClass == Object.class || valueClass == TimeSeries.Event.class ? e : dataTypes.getByClass(valueClass).readAs(valueClass, (Bytes)e.value());
            } else {
                DataType<?> dataType = topicTypeToDataType.get(type);
                value = (TimeSeries.Event)dataType.readAs(valueClass, bytesValue);
            }
            int propertiesIndex = topicResult.propertiesIndex();
            resultList.add(new TopicResultImpl<TimeSeries.Event>(topicResult.path(), type, value, properties.isEmpty() ? Collections.emptyMap() : properties.get(propertiesIndex), topicResult.sizeInfo()));
        }
        return new FetchResultImpl<V>(Collections.unmodifiableList(resultList), result.hasMore());
    }

    private FetchResultImpl(List<Topics.FetchResult.TopicResult<V>> results, boolean hasMore) {
        this.results = results;
        this.hasMore = hasMore;
    }

    @Override
    public List<Topics.FetchResult.TopicResult<V>> results() {
        return this.results;
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public int size() {
        return this.results().size();
    }

    @Override
    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.results, this.hasMore);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FetchResultImpl other = (FetchResultImpl)obj;
        return this.hasMore == other.hasMore && this.results.equals(other.results);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("FetchResult [results=").append(this.results).append(", hasMore=").append(this.hasMore).append(']');
        return sb.toString();
    }

    @Immutable
    static final class TopicResultImpl<T>
    implements Topics.FetchResult.TopicResult<T> {
        private final String path;
        private final TopicType type;
        private final T value;
        private final Map<String, String> properties;
        private final FetchTopicSizeInfo topicSizeInfo;

        TopicResultImpl(String path, TopicType type, T value, Map<String, String> properties, FetchTopicSizeInfo topicSizeInfo) {
            this.path = path;
            this.type = type;
            this.value = value;
            this.properties = properties;
            this.topicSizeInfo = topicSizeInfo;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        public TopicType type() {
            return this.type;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public TopicSpecification specification() {
            return new TopicSpecificationImpl(this.type, this.properties);
        }

        @Override
        public int valueSize() {
            return this.topicSizeInfo.valueSize();
        }

        @Override
        public int valueCount() {
            return this.topicSizeInfo.valueCount();
        }

        @Override
        public long valueTotalSize() {
            return this.topicSizeInfo.valueTotalSize();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.path, this.properties, this.type, this.value, this.topicSizeInfo});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TopicResultImpl other = (TopicResultImpl)obj;
            return Objects.equals(this.path, other.path) && Objects.equals(this.properties, other.properties) && this.type == other.type && Objects.equals(this.value, other.value) && Objects.equals(this.topicSizeInfo, other.topicSizeInfo);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(100);
            sb.append("TopicResult [path=").append(this.path).append(", type=").append((Object)this.type).append(", value=").append(this.value).append(", topicSizeInfo=").append(this.topicSizeInfo).append(", properties=").append(this.properties).append(']');
            return sb.toString();
        }
    }
}

