/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.topics.impl;

import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.topics.TopicSelector;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.client.topics.impl.FetchContext;
import com.pushtechnology.diffusion.client.topics.impl.FetchResultImpl;
import com.pushtechnology.diffusion.command.commands.fetch.FetchQuery;
import com.pushtechnology.diffusion.command.commands.fetch.FetchRange;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.internal.BytesDataType;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.timeseries.datatype.TimeSeriesEventDataType;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

@Immutable
public final class FetchRequestImpl<V>
implements Topics.FetchRequest<V> {
    static final TimeSeriesEventDataType<IBytes> TIME_SERIES_DATA_TYPE = new TimeSeriesEventDataType<IBytes>("event data type", BytesDataType.INSTANCE);
    private final FetchContext context;
    private final FetchRange range;
    private final Set<TopicType> topicTypes;
    private final Class<? extends V> valueClass;
    private final boolean withProperties;
    private final int limit;
    private final int maximumResultSize;
    private final int deepBranchDepth;
    private final int deepBranchLimit;
    private final boolean withUnpublishedDelayedTopics;
    private final boolean withSizes;

    public FetchRequestImpl(FetchContext context) {
        this(context, FetchRange.UNBOUNDED, ALL_TYPES, null, false, Integer.MAX_VALUE, context.getMaximumMessageSize(), Integer.MAX_VALUE, Integer.MAX_VALUE, false, false);
    }

    private FetchRequestImpl(FetchContext context, FetchRange range, Set<TopicType> topicTypes, Class<? extends V> valueClass, boolean withProperties, int limit, int maximumResultSize, int deepBranchDepth, int deepBranchLimit, boolean withUnpublishedDelayedTopics, boolean withSizes) {
        this.context = context;
        this.range = range;
        this.topicTypes = topicTypes;
        this.valueClass = valueClass;
        this.withProperties = withProperties;
        this.limit = limit;
        this.maximumResultSize = maximumResultSize;
        this.deepBranchDepth = deepBranchDepth;
        this.deepBranchLimit = deepBranchLimit;
        this.withUnpublishedDelayedTopics = withUnpublishedDelayedTopics;
        this.withSizes = withSizes;
    }

    @Override
    public Topics.FetchRequest<V> from(String topicPath) {
        return new FetchRequestImpl<V>(this.context, new FetchRange(new FetchRange.Limit(Objects.requireNonNull(topicPath, "topicPath is null"), true), this.range.to()), this.topicTypes, this.valueClass, this.withProperties, this.limit, this.maximumResultSize, this.deepBranchDepth, this.deepBranchLimit, this.withUnpublishedDelayedTopics, this.withSizes);
    }

    @Override
    public Topics.FetchRequest<V> after(String topicPath) {
        return new FetchRequestImpl<V>(this.context, new FetchRange(new FetchRange.Limit(Objects.requireNonNull(topicPath, "topicPath is null"), false), this.range.to()), this.topicTypes, this.valueClass, this.withProperties, this.limit, this.maximumResultSize, this.deepBranchDepth, this.deepBranchLimit, this.withUnpublishedDelayedTopics, this.withSizes);
    }

    @Override
    public Topics.FetchRequest<V> to(String topicPath) {
        return new FetchRequestImpl<V>(this.context, new FetchRange(this.range.from(), new FetchRange.Limit(Objects.requireNonNull(topicPath, "topicPath is null"), true)), this.topicTypes, this.valueClass, this.withProperties, this.limit, this.maximumResultSize, this.deepBranchDepth, this.deepBranchLimit, this.withUnpublishedDelayedTopics, this.withSizes);
    }

    @Override
    public Topics.FetchRequest<V> before(String topicPath) {
        return new FetchRequestImpl<V>(this.context, new FetchRange(this.range.from(), new FetchRange.Limit(Objects.requireNonNull(topicPath, "topicPath is null"), false)), this.topicTypes, this.valueClass, this.withProperties, this.limit, this.maximumResultSize, this.deepBranchDepth, this.deepBranchLimit, this.withUnpublishedDelayedTopics, this.withSizes);
    }

    @Override
    public Topics.FetchRequest<V> topicTypes(Set<TopicType> types) {
        if (Objects.requireNonNull(types, "types is null").isEmpty()) {
            throw new IllegalArgumentException("No types specified");
        }
        for (TopicType topicType : types) {
            if (!ALL_TYPES.contains((Object)topicType)) {
                throw new IllegalArgumentException("Invalid topic type " + String.valueOf((Object)topicType));
            }
            if (this.valueClass == null || this.canReadAs(topicType, this.valueClass) || topicType == TopicType.TIME_SERIES) continue;
            throw new IllegalArgumentException("Topic type " + String.valueOf((Object)topicType) + " can not be read as " + String.valueOf(this.valueClass));
        }
        return new FetchRequestImpl<V>(this.context, this.range, EnumSet.copyOf(types), this.valueClass, this.withProperties, this.limit, this.maximumResultSize, this.deepBranchDepth, this.deepBranchLimit, this.withUnpublishedDelayedTopics, this.withSizes);
    }

    @Override
    public <T> Topics.FetchRequest<T> withValues(Class<? extends T> classOfT) {
        Set<TopicType> selectedTopicTypes;
        if (classOfT != null) {
            selectedTopicTypes = EnumSet.copyOf(this.topicTypes);
            for (TopicType topicType : this.topicTypes) {
                if (this.canReadAs(topicType, classOfT)) continue;
                selectedTopicTypes.remove((Object)topicType);
            }
            if (selectedTopicTypes.isEmpty()) {
                throw new IllegalArgumentException("No selected topic types can be read as " + String.valueOf(classOfT));
            }
        } else {
            selectedTopicTypes = this.topicTypes;
        }
        return new FetchRequestImpl<T>(this.context, this.range, selectedTopicTypes, classOfT, this.withProperties, this.limit, this.maximumResultSize, this.deepBranchDepth, this.deepBranchLimit, this.withUnpublishedDelayedTopics, this.withSizes);
    }

    @Override
    public Topics.FetchRequest<V> withSizes() {
        return new FetchRequestImpl<V>(this.context, this.range, this.topicTypes, this.valueClass, this.withProperties, this.limit, this.maximumResultSize, this.deepBranchDepth, this.deepBranchLimit, this.withUnpublishedDelayedTopics, true);
    }

    @Override
    public Topics.FetchRequest<V> withProperties() {
        return new FetchRequestImpl<V>(this.context, this.range, this.topicTypes, this.valueClass, true, this.limit, this.maximumResultSize, this.deepBranchDepth, this.deepBranchLimit, this.withUnpublishedDelayedTopics, this.withSizes);
    }

    @Override
    public Topics.FetchRequest<V> first(int number) {
        return new FetchRequestImpl<V>(this.context, this.range, this.topicTypes, this.valueClass, this.withProperties, FetchRequestImpl.requireNonNegative(number, "number"), this.maximumResultSize, this.deepBranchDepth, this.deepBranchLimit, this.withUnpublishedDelayedTopics, this.withSizes);
    }

    @Override
    public Topics.FetchRequest<V> last(int number) {
        return new FetchRequestImpl<V>(this.context, this.range, this.topicTypes, this.valueClass, this.withProperties, 0 - FetchRequestImpl.requireNonNegative(number, "number"), this.maximumResultSize, this.deepBranchDepth, this.deepBranchLimit, this.withUnpublishedDelayedTopics, this.withSizes);
    }

    @Override
    public Topics.FetchRequest<V> maximumResultSize(int maximum) {
        return new FetchRequestImpl<V>(this.context, this.range, this.topicTypes, this.valueClass, this.withProperties, this.limit, Math.min(this.context.getMaximumMessageSize(), FetchRequestImpl.requireNonNegative(maximum, "maximumSize")), this.deepBranchDepth, this.deepBranchLimit, this.withUnpublishedDelayedTopics, this.withSizes);
    }

    @Override
    public Topics.FetchRequest<V> limitDeepBranches(int branchDepth, int branch) {
        return new FetchRequestImpl<V>(this.context, this.range, this.topicTypes, this.valueClass, this.withProperties, this.limit, this.maximumResultSize, FetchRequestImpl.requireNonNegative(branchDepth, "deepBranchDepth"), FetchRequestImpl.requireNonNegative(branch, "deepBranchLimit"), this.withUnpublishedDelayedTopics, this.withSizes);
    }

    @Override
    public Topics.FetchRequest<V> withUnpublishedDelayedTopics() {
        return new FetchRequestImpl<V>(this.context, this.range, this.topicTypes, this.valueClass, this.withProperties, this.limit, this.maximumResultSize, this.deepBranchDepth, this.deepBranchLimit, true, this.withSizes);
    }

    @Override
    public CompletableFuture<Topics.FetchResult<V>> fetch(TopicSelector topics) {
        FetchQuery query = new FetchQuery(Objects.requireNonNull(topics, "topics is null").getExpression(), this.range, this.topicTypes, this.valueClass != null, this.withProperties, this.limit, this.maximumResultSize, this.deepBranchDepth, this.deepBranchLimit, this.withUnpublishedDelayedTopics, this.withSizes);
        return this.context.service().sendCommand(query).thenApply(r -> FetchResultImpl.create(this.valueClass, r, this.context.topicTypeToDataType(), this.context.getDataTypes()));
    }

    @Override
    public CompletableFuture<Topics.FetchResult<V>> fetch(String topics) {
        return this.fetch(this.context.selectorParser().parse(Objects.requireNonNull(topics, "topics is null")));
    }

    private boolean canReadAs(TopicType topicType, Class<?> targetClass) {
        if (topicType == TopicType.TIME_SERIES) {
            return TIME_SERIES_DATA_TYPE.canReadAs(targetClass);
        }
        DataType<?> dataType = this.context.topicTypeToDataType().get(topicType);
        return dataType.canReadAs(targetClass);
    }

    private static int requireNonNegative(int n, String parameter) {
        if (n < 0) {
            throw new IllegalArgumentException(parameter + " must be non-negative");
        }
        return n;
    }
}

