/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.session.impl;

import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.session.impl.SessionLockRequest;
import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@CommandSerialiser(spec="session-lock-request", valueType=SessionLockRequest.class)
public class SessionLockRequestSerialiser
extends AbstractSerialiser<SessionLockRequest> {
    static final EnumConverter<Session.SessionLockScope> SCOPE_CONVERTER = new EnumConverter.Builder<Session.SessionLockScope>(Session.SessionLockScope.class).bimap(0, Session.SessionLockScope.UNLOCK_ON_SESSION_LOSS).bimap(1, Session.SessionLockScope.UNLOCK_ON_CONNECTION_LOSS).build();

    @Override
    public void write(OutputStream out, SessionLockRequest value) throws IOException {
        EncodedDataCodec.writeString(out, value.getLockName());
        EncodedDataCodec.writeInt64(out, value.getRequestId());
        EncodedDataCodec.writeByte(out, SCOPE_CONVERTER.toByte(value.getScope()));
    }

    @Override
    protected SessionLockRequest readUnchecked(InputStream in) throws IOException {
        String lockName = EncodedDataCodec.readString(in);
        long requestId = EncodedDataCodec.readInt64(in);
        Session.SessionLockScope scope = SCOPE_CONVERTER.fromByte(EncodedDataCodec.readByte(in));
        return new SessionLockRequest(lockName, requestId, scope);
    }
}

