/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.session.impl;

import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.session.impl.SessionLockAcquisition;
import com.pushtechnology.diffusion.client.session.impl.SessionLockRequestSerialiser;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="session-lock-acquisition", valueType=SessionLockAcquisition.class)
public final class SessionLockAcquisitionSerialiser
extends AbstractSerialiser<SessionLockAcquisition> {
    @Override
    public void write(OutputStream out, SessionLockAcquisition value) throws IOException {
        EncodedDataCodec.writeString(out, value.getLockName());
        EncodedDataCodec.writeInt64(out, value.getSequence());
        EncodedDataCodec.writeByte(out, SessionLockRequestSerialiser.SCOPE_CONVERTER.toByte(value.getScope()));
    }

    @Override
    protected SessionLockAcquisition readUnchecked(InputStream in) throws IOException {
        String lockName = EncodedDataCodec.readString(in);
        long sequence = EncodedDataCodec.readInt64(in);
        Session.SessionLockScope scope = SessionLockRequestSerialiser.SCOPE_CONVERTER.fromByte(EncodedDataCodec.readByte(in));
        return new SessionLockAcquisition(lockName, sequence, scope);
    }
}

