/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.session.impl;

import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.java7.Java7;
import com.pushtechnology.diffusion.journal.Journable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class SessionLockAcquisition
implements Journable {
    private final String lockName;
    private final long sequence;
    private final Session.SessionLockScope scope;

    public SessionLockAcquisition(String lockName, long sequence, Session.SessionLockScope scope) {
        this.lockName = lockName;
        this.sequence = sequence;
        this.scope = scope;
    }

    public String getLockName() {
        return this.lockName;
    }

    public long getSequence() {
        return this.sequence;
    }

    public Session.SessionLockScope getScope() {
        return this.scope;
    }

    public int hashCode() {
        int result = this.lockName.hashCode();
        result = 31 * result + Java7.longHashCode(this.sequence);
        result = 31 * result + this.scope.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SessionLockAcquisition)) {
            return false;
        }
        SessionLockAcquisition other = (SessionLockAcquisition)o;
        return this.sequence == other.sequence && this.scope == other.scope && this.lockName.equals(other.lockName);
    }

    public String toString() {
        return "SessionLockAcquisition[" + this.lockName + ", " + this.sequence + ", " + String.valueOf((Object)this.scope) + "]";
    }

    @Override
    public Map<String, Object> getJournableContext() {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>(3);
        context.put("lock", this.lockName);
        context.put("sequence", this.sequence);
        context.put("scope", (Object)this.scope);
        return context;
    }
}

