/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.session.impl;

import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.internal.session.SessionErrorImpl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import org.slf4j.Logger;

final class SessionListenerAdapter
implements InternalSession.InternalSessionListener {
    private static final Logger LOG = I18nLogger.getLogger(SessionListenerAdapter.class);
    private final Session session;
    private final Session.Listener sessionListener;

    SessionListenerAdapter(Session session, Session.Listener sessionListener) {
        this.session = session;
        this.sessionListener = sessionListener;
    }

    @Override
    public void onSessionEvent(InternalSession internalSession, Session.State oldState, Session.State newState) {
        try {
            this.sessionListener.onSessionStateChanged(this.session, oldState, newState);
        }
        catch (Exception t) {
            LOG.error("SESSION_LISTENER_EXCEPTION", (Object)this.sessionListener, (Object)t);
            internalSession.getErrorHandler().notifyError(new SessionErrorImpl(t.toString(), t));
        }
        catch (Throwable t) {
            LOG.error("SESSION_LISTENER_EXCEPTION", (Object)this.sessionListener, (Object)t);
            internalSession.getErrorHandler().notifyError(new SessionErrorImpl(t.toString(), t));
            throw t;
        }
    }

    public int hashCode() {
        return this.sessionListener.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(SessionListenerAdapter.class)) {
            return false;
        }
        SessionListenerAdapter other = (SessionListenerAdapter)o;
        return this.sessionListener.equals(other.sessionListener);
    }
}

