/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.session.impl;

import com.pushtechnology.diffusion.client.internal.session.ClientSessionLocks;
import com.pushtechnology.diffusion.client.internal.session.ClientSessionProperties;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.Feature;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.session.SessionAttributes;
import com.pushtechnology.diffusion.client.session.SessionId;
import com.pushtechnology.diffusion.client.session.impl.SessionListenerAdapter;
import com.pushtechnology.diffusion.java7.Functions;
import com.pushtechnology.repackaged.picocontainer.PicoContainer;
import com.pushtechnology.repackaged.picocontainer.injectors.AbstractInjector;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.Immutable;

@Immutable
public final class SessionImpl
implements Session {
    private final PicoContainer sessionDependencies;
    private final InternalSession internalSession;

    public SessionImpl(PicoContainer sessionDependencies, InternalSession internalSession) {
        this.sessionDependencies = sessionDependencies;
        this.internalSession = internalSession;
    }

    InternalSession getInternalSession() {
        return this.internalSession;
    }

    @Override
    public String getPrincipal() {
        return this.internalSession.getPrincipal();
    }

    @Override
    public SessionId getSessionId() {
        return this.internalSession.getSessionId();
    }

    @Override
    public Session.State getState() {
        return this.internalSession.getState();
    }

    @Override
    public void close() {
        this.internalSession.close();
    }

    @Override
    public <T extends Feature> T feature(Class<T> featureInterface) throws IllegalArgumentException, UnsupportedOperationException {
        Feature feature;
        Objects.requireNonNull(featureInterface, "featureInterface is null");
        if (!featureInterface.isInterface()) {
            throw new IllegalArgumentException("Feature interface is not an interface");
        }
        try {
            feature = (Feature)this.sessionDependencies.getComponent(featureInterface);
        }
        catch (AbstractInjector.UnsatisfiableDependenciesException e) {
            throw new IllegalStateException("Could not get feature " + featureInterface.getSimpleName() + " due to a dependency issue", e);
        }
        if (feature == null) {
            throw new UnsupportedOperationException("Feature " + featureInterface.getSimpleName() + " unavailable");
        }
        return (T)feature;
    }

    @Override
    public SessionAttributes getAttributes() {
        return this.sessionDependencies.getComponent(SessionAttributes.class);
    }

    public String toString() {
        return "<" + String.valueOf(this.getSessionId()) + " " + String.valueOf((Object)this.getState()) + ">";
    }

    @Override
    public void addListener(Session.Listener listener) {
        this.internalSession.addListener(new SessionListenerAdapter(this, Objects.requireNonNull(listener, "listener is null")));
    }

    @Override
    public void removeListener(Session.Listener listener) {
        this.internalSession.removeListener(new SessionListenerAdapter(this, Objects.requireNonNull(listener, "listener is null")));
    }

    @Override
    public CompletableFuture<Session.SessionLock> lock(String lockName) {
        return this.lock(lockName, Session.SessionLockScope.UNLOCK_ON_SESSION_LOSS);
    }

    @Override
    public CompletableFuture<Session.SessionLock> lock(String lockName, Session.SessionLockScope scope) {
        ClientSessionLocks locks = this.sessionDependencies.getComponent(ClientSessionLocks.class);
        CompletableFuture<Session.SessionLock> cf = locks.lock(lockName, scope);
        CompletionStage cf2 = cf.thenApply(Functions.identity());
        ((CompletableFuture)cf2).whenComplete((arg_0, arg_1) -> SessionImpl.lambda$lock$0((CompletableFuture)cf2, cf, arg_0, arg_1));
        return cf2;
    }

    @Override
    public CompletableFuture<Map<String, String>> getSessionProperties() {
        return this.sessionDependencies.getComponent(ClientSessionProperties.class).getSessionProperties();
    }

    private static /* synthetic */ void lambda$lock$0(CompletableFuture cf2, CompletableFuture cf, Session.SessionLock v, Throwable t) {
        if (cf2.isCancelled()) {
            cf.cancel(true);
        }
    }
}

