/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.session.impl;

import com.pushtechnology.diffusion.api.internal.connection.ConnectionTypeProvider;
import com.pushtechnology.diffusion.api.internal.connection.InternalConnectionType;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.AuthenticationException;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.session.SessionAttributes;
import com.pushtechnology.diffusion.client.session.SessionEstablishmentException;
import com.pushtechnology.diffusion.client.session.SessionEstablishmentTransientException;
import com.pushtechnology.diffusion.client.session.SessionFactory;
import com.pushtechnology.diffusion.client.session.impl.ErrorHandlerAdapter;
import com.pushtechnology.diffusion.client.session.impl.ExtendedSessionFactory;
import com.pushtechnology.diffusion.client.session.impl.SessionAttributesBuilder;
import com.pushtechnology.diffusion.client.session.impl.SessionContainerFactory;
import com.pushtechnology.diffusion.client.session.impl.SessionImpl;
import com.pushtechnology.diffusion.client.session.proxy.HTTPProxyAuthentication;
import com.pushtechnology.diffusion.client.session.reconnect.ReconnectionStrategy;
import com.pushtechnology.diffusion.client.session.retry.RetryStrategy;
import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.comms.connection.ProtocolVersion;
import com.pushtechnology.diffusion.connection.activity.monitor.ConnectionActivityMonitorFactory;
import com.pushtechnology.diffusion.connection.activity.monitor.SessionActivityMonitor;
import com.pushtechnology.diffusion.connection.activity.monitor.SessionActivityMonitorImpl;
import com.pushtechnology.diffusion.gateway.GatewayFrameworkSessionFactory;
import com.pushtechnology.diffusion.io.nio.NetworkChannel;
import com.pushtechnology.diffusion.java7.Functions;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.util.concurrent.threads.CommonThreadPools;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.repackaged.picocontainer.MutablePicoContainer;
import com.pushtechnology.repackaged.picocontainer.PicoContainer;
import com.pushtechnology.repackaged.picocontainer.injectors.ProviderAdapter;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;

@Immutable
public final class SessionFactoryImpl
implements ExtendedSessionFactory,
GatewayFrameworkSessionFactory {
    private static final boolean DISABLE_ACTIVITY_MONITOR = ConfigurationUtils.getBooleanSystemProperty("diffusion.activity.monitor.disable");
    private static final Logger LOG = I18nLogger.getLogger(SessionFactoryImpl.class);
    private final Context theContext;
    private final String thePrincipal;
    private final Credentials theCredentials;
    private final Map<String, String> theProperties;
    private final SessionAttributesBuilder theAttributesBuilder;
    private final Session.Listener theListener;
    private final Session.ErrorHandler theErrorHandler;
    private final ProtocolVersion requestedProtocol;
    private final InternalConnectionType connectionType;
    private final String theServerUUID;

    public SessionFactoryImpl(MutablePicoContainer globalDependencies, SessionContainerFactory sessionContainerFactory, Credentials.Factory credentialsFactory) {
        this(new Context(globalDependencies, credentialsFactory, sessionContainerFactory), "", credentialsFactory.noCredentials(), Collections.emptyMap(), SessionAttributesBuilder.DEFAULTS, null, null, ProtocolVersion.CURRENT_VERSION, ConnectionTypeProvider.connectionType(), null);
    }

    private SessionFactoryImpl(Context context, String principal, Credentials credentials, Map<String, String> properties, SessionAttributesBuilder attributesBuilder, Session.Listener listener, Session.ErrorHandler errorHandler, ProtocolVersion requestedProtocol, InternalConnectionType connectionType, String serverUUID) {
        this.theContext = context;
        this.thePrincipal = principal;
        this.theCredentials = credentials;
        this.theProperties = properties;
        this.theAttributesBuilder = attributesBuilder;
        this.theListener = listener;
        this.theErrorHandler = errorHandler;
        this.requestedProtocol = requestedProtocol;
        this.connectionType = connectionType;
        this.theServerUUID = serverUUID;
    }

    private ScheduledExecutorService backgroundThreadPool() {
        return this.theContext.globalDependencies.getComponent(CommonThreadPools.class).getBackgroundThreadPool();
    }

    @Override
    public CompletableFuture<Session> openAsync() {
        return CompletableFuture.supplyAsync(this::open, this.backgroundThreadPool()).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<Session> openAsync(String url) {
        Objects.requireNonNull(url, "url is null");
        return CompletableFuture.supplyAsync(() -> this.open(url), this.backgroundThreadPool()).thenApply(Functions.identity());
    }

    @Override
    public Session open() throws IllegalStateException, SessionEstablishmentException, AuthenticationException {
        this.validateGatewayProperties(false);
        return this.openSession(this.theAttributesBuilder.build());
    }

    @Override
    public Session open(String url) {
        this.validateGatewayProperties(false);
        return this.openSession(this.theAttributesBuilder.build(url));
    }

    @Override
    public Session openGatewayFramework() {
        this.validateGatewayProperties(true);
        return this.openSession(this.theAttributesBuilder.build());
    }

    @Override
    public Session openReverse(String url, NetworkChannel networkChannel) {
        return (Session)this.theContext.sessionContainerFactory.startReverseSession(this.theAttributesBuilder.build(url), this.thePrincipal, this.theCredentials, this.theProperties, this.requestedProtocol, this.connectionType, this.theServerUUID, networkChannel, this.sessionHook());
    }

    private void validateGatewayProperties(boolean framework) {
        String gatewayType = this.theProperties.get("$GatewayType");
        String gatewayId = this.theProperties.get("$GatewayId");
        if (gatewayType == null && gatewayId == null) {
            return;
        }
        if (gatewayType == null || gatewayId == null) {
            throw new IllegalArgumentException("$GatewayType and $GatewayId must both be specified");
        }
        this.validateAndNormaliseGatewayType(gatewayType.trim(), framework);
        this.validateAndNormaliseGatewayId(gatewayId.trim());
    }

    private void validateAndNormaliseGatewayType(String gatewayType, boolean framework) {
        String type = framework && gatewayType.startsWith("$") ? gatewayType.substring(1) : gatewayType;
        if (type.isEmpty() || !type.matches("^[A-Za-z0-9-_ ]*$")) {
            throw new IllegalArgumentException("$GatewayType '" + type + "' is invalid - must be non empty alphanumeric");
        }
        this.theProperties.put("$GatewayType", (String)(framework ? "$" + type : type));
    }

    private void validateAndNormaliseGatewayId(String gatewayId) {
        if (gatewayId.isEmpty()) {
            throw new IllegalArgumentException("$GatewayId is empty");
        }
        this.theProperties.put("$GatewayId", gatewayId);
    }

    private Session openSession(SessionAttributes attributes) {
        RetryStrategy retryStrategy = attributes.getInitialRetryStrategy();
        int attempts = retryStrategy.getAttempts();
        long interval = retryStrategy.getInterval();
        try {
            return this.tryOpenSession(attributes);
        }
        catch (SessionEstablishmentTransientException ex) {
            if (attempts == 0) {
                throw ex;
            }
            if (attempts == Integer.MAX_VALUE) {
                LOG.info("SESSION_CONNECTION_RETRYING_INDEFINITELY", (Object)interval);
            } else {
                LOG.info("SESSION_CONNECTION_RETRYING", (Object)attempts, (Object)interval);
            }
            for (int i = 0; i < attempts; ++i) {
                try {
                    TimeUnit.MILLISECONDS.sleep(interval);
                    return this.tryOpenSession(attributes);
                }
                catch (SessionEstablishmentTransientException ex2) {
                    LOG.info("SESSION_CONNECTION_RETRY_FAILED", (Object)(i + 1), (Object)interval);
                    continue;
                }
                catch (InterruptedException ex3) {
                    throw new SessionEstablishmentException(ex3);
                }
            }
            throw new SessionEstablishmentException("Failed to establish session after retrying " + attempts + " times at an interval of " + interval + " milliseconds");
        }
    }

    private Session tryOpenSession(SessionAttributes attributes) {
        return (Session)this.theContext.sessionContainerFactory.startSession(attributes, this.thePrincipal, this.theCredentials, this.theProperties, this.requestedProtocol, this.connectionType, this.theServerUUID, this.sessionHook());
    }

    private <T> BiFunction<InternalSession, MutablePicoContainer, T> sessionHook() {
        return (internalSession, sessionDependencies) -> {
            SessionImpl session = new SessionImpl((PicoContainer)sessionDependencies, (InternalSession)internalSession);
            sessionDependencies.addComponent(session);
            internalSession.setErrorHandler(new ErrorHandlerAdapter(session, this.theErrorHandler != null ? this.theErrorHandler : new Session.ErrorHandler.Default()));
            if (this.theListener != null) {
                session.addListener(this.theListener);
            }
            return session;
        };
    }

    @Override
    public SessionFactory principal(String principal) {
        return new SessionFactoryImpl(this.theContext, Objects.requireNonNull(principal, "principal is null"), this.theCredentials, this.theProperties, this.theAttributesBuilder, this.theListener, this.theErrorHandler, this.requestedProtocol, this.connectionType, this.theServerUUID);
    }

    @Override
    public SessionFactory credentials(Credentials credentials) {
        return new SessionFactoryImpl(this.theContext, this.thePrincipal, Objects.requireNonNull(credentials, "credentials is null"), this.theProperties, this.theAttributesBuilder, this.theListener, this.theErrorHandler, this.requestedProtocol, this.connectionType, this.theServerUUID);
    }

    @Override
    public SessionFactory noCredentials() {
        return this.credentials(this.theContext.credentialsFactory.noCredentials());
    }

    @Override
    public SessionFactory password(String password) {
        return this.credentials(this.theContext.credentialsFactory.password(Objects.requireNonNull(password, "password is null")));
    }

    @Override
    public SessionFactory customCredentials(byte[] bytes) {
        return this.credentials(this.theContext.credentialsFactory.custom(Objects.requireNonNull(bytes, "bytes is null")));
    }

    @Override
    public SessionFactory connectionTimeout(int timeout) throws IllegalArgumentException {
        return this.withAttributes(this.theAttributesBuilder.connectionTimeout(timeout));
    }

    @Override
    public SessionFactory initialRetryStrategy(RetryStrategy strategy) {
        return this.withAttributes(this.theAttributesBuilder.initialRetryStrategy(strategy));
    }

    @Override
    public SessionFactory noReconnection() {
        return this.withAttributes(this.theAttributesBuilder.reconnectionTimeout(0));
    }

    @Override
    public SessionFactory reconnectionTimeout(int timeout) throws IllegalArgumentException {
        return this.withAttributes(this.theAttributesBuilder.reconnectionTimeout(timeout));
    }

    @Override
    public SessionFactory reconnectionStrategy(ReconnectionStrategy strategy) throws IllegalArgumentException {
        return this.withAttributes(this.theAttributesBuilder.reconnectionStrategy(strategy));
    }

    @Override
    public SessionFactory inputBufferSize(int size) throws IllegalArgumentException {
        return this.withAttributes(this.theAttributesBuilder.inputBufferSize(size));
    }

    @Override
    public SessionFactory outputBufferSize(int size) throws IllegalArgumentException {
        return this.withAttributes(this.theAttributesBuilder.outputBufferSize(size));
    }

    @Override
    public SessionFactory localSocketAddress(SocketAddress address) {
        return this.withAttributes(this.theAttributesBuilder.localSocketAddress(address));
    }

    @Override
    public SessionFactory sslContext(SSLContext sslContext) throws IllegalArgumentException {
        return this.withAttributes(this.theAttributesBuilder.sslContext(sslContext));
    }

    @Override
    public SessionFactory writeTimeout(int timeout) throws IllegalArgumentException {
        return this.withAttributes(this.theAttributesBuilder.writeTimeout(timeout));
    }

    @Override
    public SessionFactory maximumMessageSize(int size) throws IllegalArgumentException {
        return this.withAttributes(this.theAttributesBuilder.maximumMessageSize(size));
    }

    @Override
    public SessionFactory httpProxy(String host, int port) throws IllegalArgumentException {
        return this.withAttributes(this.theAttributesBuilder.httpProxy(host, port));
    }

    @Override
    public SessionFactory httpProxy(String host, int port, HTTPProxyAuthentication proxyAuthentication) throws IllegalArgumentException {
        return this.withAttributes(this.theAttributesBuilder.httpProxy(host, port, proxyAuthentication));
    }

    @Override
    public SessionFactory serverHost(String host) {
        return this.withAttributes(this.theAttributesBuilder.serverHost(host));
    }

    @Override
    public SessionFactory serverPort(int port) {
        return this.withAttributes(this.theAttributesBuilder.serverPort(port));
    }

    @Override
    public SessionFactory transports(SessionAttributes.Transport ... transports) {
        return this.withAttributes(this.theAttributesBuilder.requestedTransports(transports));
    }

    @Override
    public SessionFactory secureTransport(boolean secureTransport) {
        return this.withAttributes(this.theAttributesBuilder.secureTransport(secureTransport));
    }

    @Override
    public SessionFactory requestPath(String requestPath) {
        return this.withAttributes(this.theAttributesBuilder.requestPath(requestPath));
    }

    @Override
    public SessionFactory listener(Session.Listener listener) {
        return new SessionFactoryImpl(this.theContext, this.thePrincipal, this.theCredentials, this.theProperties, this.theAttributesBuilder, listener, this.theErrorHandler, this.requestedProtocol, this.connectionType, this.theServerUUID);
    }

    @Override
    public SessionFactory errorHandler(Session.ErrorHandler errorHandler) {
        return new SessionFactoryImpl(this.theContext, this.thePrincipal, this.theCredentials, this.theProperties, this.theAttributesBuilder, this.theListener, errorHandler, this.requestedProtocol, this.connectionType, this.theServerUUID);
    }

    @Override
    public SessionFactory recoveryBufferSize(int size) {
        return this.withAttributes(this.theAttributesBuilder.recoveryBufferSize(size));
    }

    @Override
    public SessionFactory maximumQueueSize(int size) throws IllegalArgumentException {
        return this.withAttributes(this.theAttributesBuilder.maximumQueueSize(size));
    }

    @Override
    public SessionFactory property(String key, String value) {
        HashMap<String, String> propertyMap = new HashMap<String, String>(this.theProperties);
        propertyMap.put(Objects.requireNonNull(key, "key is null"), Objects.requireNonNull(value, "value is null"));
        return new SessionFactoryImpl(this.theContext, this.thePrincipal, this.theCredentials, propertyMap, this.theAttributesBuilder, this.theListener, this.theErrorHandler, this.requestedProtocol, this.connectionType, this.theServerUUID);
    }

    @Override
    public SessionFactory properties(Map<String, String> properties) {
        HashMap<String, String> propertyMap = new HashMap<String, String>(this.theProperties);
        propertyMap.putAll(Objects.requireNonNull(properties, "properties is null"));
        return new SessionFactoryImpl(this.theContext, this.thePrincipal, this.theCredentials, propertyMap, this.theAttributesBuilder, this.theListener, this.theErrorHandler, this.requestedProtocol, this.connectionType, this.theServerUUID);
    }

    @Override
    public ExtendedSessionFactory requestedProtocol(ProtocolVersion protocol) {
        return new SessionFactoryImpl(this.theContext, this.thePrincipal, this.theCredentials, this.theProperties, this.theAttributesBuilder, this.theListener, this.theErrorHandler, protocol, this.connectionType, this.theServerUUID);
    }

    @Override
    public ExtendedSessionFactory requestedConnectionType(InternalConnectionType requestedConnectionType) {
        return new SessionFactoryImpl(this.theContext, this.thePrincipal, this.theCredentials, this.theProperties, this.theAttributesBuilder, this.theListener, this.theErrorHandler, this.requestedProtocol, requestedConnectionType, this.theServerUUID);
    }

    @Override
    public ExtendedSessionFactory serverUUID(String serverUUID) {
        return new SessionFactoryImpl(this.theContext, this.thePrincipal, this.theCredentials, this.theProperties, this.theAttributesBuilder, this.theListener, this.theErrorHandler, this.requestedProtocol, this.connectionType, serverUUID);
    }

    private SessionFactory withAttributes(SessionAttributesBuilder attributesBuilder) {
        return new SessionFactoryImpl(this.theContext, this.thePrincipal, this.theCredentials, this.theProperties, attributesBuilder, this.theListener, this.theErrorHandler, this.requestedProtocol, this.connectionType, this.theServerUUID);
    }

    @Immutable
    private static final class Context {
        private final MutablePicoContainer globalDependencies;
        private final Credentials.Factory credentialsFactory;
        private final SessionContainerFactory sessionContainerFactory;

        Context(MutablePicoContainer globalDependencies, Credentials.Factory credentialsFactory, SessionContainerFactory sessionContainerFactory) {
            this.globalDependencies = globalDependencies;
            this.credentialsFactory = credentialsFactory;
            this.sessionContainerFactory = sessionContainerFactory;
        }
    }

    public static final class SessionActivityMonitorProvider
    extends ProviderAdapter {
        public SessionActivityMonitor provide(ConnectionActivityMonitorFactory connectionActivityMonitorFactory) {
            if (DISABLE_ACTIVITY_MONITOR) {
                return SessionActivityMonitor.NOOP;
            }
            return new SessionActivityMonitorImpl(connectionActivityMonitorFactory);
        }
    }
}

