/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.session.impl;

import com.pushtechnology.diffusion.api.internal.connection.InternalConnectionType;
import com.pushtechnology.diffusion.client.internal.routing.TopicRouting;
import com.pushtechnology.diffusion.client.internal.services.AuthenticatorRegistrationImpl;
import com.pushtechnology.diffusion.client.internal.services.FilterResponseListenerImpl;
import com.pushtechnology.diffusion.client.internal.services.MissingTopicHandlerRegistrationImpl;
import com.pushtechnology.diffusion.client.internal.services.MutableServiceRegistry;
import com.pushtechnology.diffusion.client.internal.services.NotifySubscriptionService;
import com.pushtechnology.diffusion.client.internal.services.NotifyUnsubscriptionService;
import com.pushtechnology.diffusion.client.internal.services.QueueEventHandlerRegistrationImpl;
import com.pushtechnology.diffusion.client.internal.services.RequestReceiverRegistrationImpl;
import com.pushtechnology.diffusion.client.internal.services.RequestResponseService;
import com.pushtechnology.diffusion.client.internal.services.ServiceRegistryImpl;
import com.pushtechnology.diffusion.client.internal.services.SessionEventRegistrationImpl;
import com.pushtechnology.diffusion.client.internal.services.TopicNotificationListenerRegistrationImpl;
import com.pushtechnology.diffusion.client.internal.services.ping.MonitoredPingService;
import com.pushtechnology.diffusion.client.internal.session.ClientSessionLocksImpl;
import com.pushtechnology.diffusion.client.internal.session.ClientSessionPropertiesImpl;
import com.pushtechnology.diffusion.client.internal.session.ClosedSessionListener;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.internal.session.InternalSessionFactory;
import com.pushtechnology.diffusion.client.internal.streams.RequestStreamRegistryImpl;
import com.pushtechnology.diffusion.client.session.SessionAttributes;
import com.pushtechnology.diffusion.client.session.impl.OutboundSessions;
import com.pushtechnology.diffusion.client.session.impl.SessionContainerFactory;
import com.pushtechnology.diffusion.client.session.impl.SessionEnvironmentProperty;
import com.pushtechnology.diffusion.client.session.impl.SessionFactoryImpl;
import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.command.commands.ping.PingService;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.comms.connection.ConnectionHandshakeEventListener;
import com.pushtechnology.diffusion.comms.connection.ProtocolVersion;
import com.pushtechnology.diffusion.connection.activity.monitor.SessionActivityMonitor;
import com.pushtechnology.diffusion.gateway.GatewayRegistryImpl;
import com.pushtechnology.diffusion.gateway.GatewayRequestService;
import com.pushtechnology.diffusion.io.nio.NetworkChannel;
import com.pushtechnology.repackaged.picocontainer.MutablePicoContainer;
import com.pushtechnology.repackaged.picocontainer.Parameter;
import com.pushtechnology.repackaged.picocontainer.PicoBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class SessionContainerFactoryImpl
implements SessionContainerFactory {
    private final MutablePicoContainer globalDependencies;
    private final Consumer<MutablePicoContainer> configureExtraSessionComponents;

    public SessionContainerFactoryImpl(MutablePicoContainer globalDependencies, Consumer<MutablePicoContainer> configureExtraSessionComponents) {
        this.globalDependencies = globalDependencies;
        this.configureExtraSessionComponents = configureExtraSessionComponents;
    }

    @Override
    public <T> T startSession(SessionAttributes attributes, String principal, Credentials credentials, Map<String, String> sessionProperties, ProtocolVersion requestProtocolVersion, InternalConnectionType connectionType, String serverUUID, BiFunction<InternalSession, MutablePicoContainer, T> hook) {
        return this.doStartSession(attributes, principal, credentials, sessionProperties, requestProtocolVersion, connectionType, serverUUID, null, hook);
    }

    @Override
    public <T> T startReverseSession(SessionAttributes attributes, String principal, Credentials credentials, Map<String, String> sessionProperties, ProtocolVersion requestProtocolVersion, InternalConnectionType connectionType, String serverUUID, NetworkChannel networkChannel, BiFunction<InternalSession, MutablePicoContainer, T> hook) {
        return this.doStartSession(attributes, principal, credentials, sessionProperties, requestProtocolVersion, connectionType, serverUUID, networkChannel, hook);
    }

    private <T> T doStartSession(SessionAttributes attributes, String principal, Credentials credentials, Map<String, String> sessionProperties, ProtocolVersion requestProtocolVersion, InternalConnectionType connectionType, String serverUUID, NetworkChannel networkChannel, BiFunction<InternalSession, MutablePicoContainer, T> hook) {
        ServiceRegistryImpl services = new ServiceRegistryImpl();
        final MutablePicoContainer sessionDependencies = new PicoBuilder(this.globalDependencies).withCaching().withConstructorInjection().withLifecycle().withLocking().build().addAdapter(new SessionFactoryImpl.SessionActivityMonitorProvider()).addComponent(attributes).addComponent(GatewayRegistryImpl.class).addComponent(AuthenticatorRegistrationImpl.class).addComponent(ClientSessionLocksImpl.class).addComponent(ClientSessionPropertiesImpl.class).addComponent(FilterResponseListenerImpl.class).addComponent(MissingTopicHandlerRegistrationImpl.class).addComponent(MutableServiceRegistry.class, services, new Parameter[0]).addComponent(QueueEventHandlerRegistrationImpl.class).addComponent(RequestStreamRegistryImpl.class).addComponent(RequestReceiverRegistrationImpl.class).addComponent(RequestResponseService.class).addComponent(SessionEventRegistrationImpl.class).addComponent(TopicNotificationListenerRegistrationImpl.class).addComponent((Object)connectionType);
        this.configureExtraSessionComponents.accept(sessionDependencies);
        TopicRouting topicRouting = sessionDependencies.getComponent(TopicRouting.class);
        services.add(CommonServices.SYSTEM_PING, new MonitoredPingService());
        services.add(CommonServices.USER_PING, new PingService<InternalSession>());
        services.add(CommonServices.NOTIFY_SUBSCRIPTION, new NotifySubscriptionService(topicRouting));
        services.add(CommonServices.NOTIFY_UNSUBSCRIPTION, new NotifyUnsubscriptionService(topicRouting));
        services.add(CommonServices.MESSAGING_SEND, sessionDependencies.getComponent(RequestResponseService.class));
        if (connectionType.isGatewayClient()) {
            services.add(CommonServices.GATEWAY_REQUEST, new GatewayRequestService(sessionDependencies.getComponent(GatewayRegistryImpl.class)));
        }
        InternalSessionFactory factory = this.globalDependencies.getComponent(InternalSessionFactory.class);
        final InternalSession internalSession = factory.create(attributes, sessionDependencies.getComponent(MutableServiceRegistry.class), sessionDependencies.getComponent(SessionActivityMonitor.class), topicRouting, ConnectionHandshakeEventListener.LOGGING);
        final OutboundSessions outboundSessions = this.globalDependencies.getComponent(OutboundSessions.class);
        internalSession.addListener(new ClosedSessionListener(){

            @Override
            public void onClosed() {
                outboundSessions.remove(internalSession);
                sessionDependencies.dispose();
            }
        });
        outboundSessions.add(internalSession);
        sessionDependencies.addComponent(InternalSession.class, internalSession, new Parameter[0]);
        T result = hook.apply(internalSession, sessionDependencies);
        sessionDependencies.start();
        HashMap<String, String> newSessionProperties = new HashMap<String, String>(sessionProperties);
        if (requestProtocolVersion.isEarlierThan(ProtocolVersion.PROTOCOL_28_VERSION)) {
            newSessionProperties.put("$Environment", "<UNKNOWN>");
        } else {
            newSessionProperties.put("$Environment", SessionEnvironmentProperty.getEnvironmentProperty());
        }
        if (networkChannel == null) {
            internalSession.connect(requestProtocolVersion, connectionType, principal, credentials, newSessionProperties, serverUUID);
        } else {
            internalSession.connectReverse(networkChannel, requestProtocolVersion, connectionType, principal, credentials, newSessionProperties, serverUUID);
        }
        topicRouting.wireSesssionServices(services, internalSession.getServiceLocator());
        return result;
    }
}

