/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.session.impl;

import com.pushtechnology.diffusion.api.internal.connection.DiffusionURI;
import com.pushtechnology.diffusion.api.internal.connection.ServerDetailsFactory;
import com.pushtechnology.diffusion.client.session.SessionAttributes;
import com.pushtechnology.diffusion.client.session.impl.SessionAttributesImpl;
import com.pushtechnology.diffusion.client.session.proxy.HTTPProxyAuthentication;
import com.pushtechnology.diffusion.client.session.reconnect.ReconnectionStrategy;
import com.pushtechnology.diffusion.client.session.retry.RetryStrategy;
import com.pushtechnology.diffusion.configuration.LimitTimeouts;
import com.pushtechnology.diffusion.proxy.NullHTTPProxyAuthentication;
import java.net.SocketAddress;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import net.jcip.annotations.Immutable;

@Immutable
final class SessionAttributesBuilder {
    public static final SessionAttributesBuilder DEFAULTS = new SessionAttributesBuilder(2000, 2000, 131072, 131072, Integer.MAX_VALUE, null, 60000, null, null, null, null, null, -1, null, -1, Collections.singletonList(SessionAttributes.Transport.WEBSOCKET), false, "/diffusion", 128, 1000);
    private final int theConnectionTimeout;
    private final int theWriteTimeout;
    private final int theInputBufferSize;
    private final int theOutputBufferSize;
    private final int theMaximumMessageSize;
    private final RetryStrategy theInitialRetryStrategy;
    private final int reconnectionTimeout;
    private final ReconnectionStrategy reconnectionStrategy;
    private final SocketAddress theLocalSocketAddress;
    private final SSLContext theSSLContext;
    private final HTTPProxyAuthentication theProxyAuth;
    private final String theProxyHost;
    private final int theProxyPort;
    private final String serverHost;
    private final int serverPort;
    private final List<SessionAttributes.Transport> requestedTransports;
    private final boolean isSecure;
    private final String requestPath;
    private final int recoveryBufferSize;
    private final int theMaximumQueueSize;

    private SessionAttributesBuilder(int connectionTimeout, int writeTimeout, int inputBufferSize, int outputBufferSize, int maximumMessageSize, RetryStrategy initialRetryStrategy, int reconnectionTimeout, ReconnectionStrategy reconnectionStrategy, SocketAddress localSocketAddress, SSLContext sslContext, HTTPProxyAuthentication proxyAuth, String proxyHost, int proxyPort, String serverHost, int serverPort, List<SessionAttributes.Transport> requestedTransports, boolean isSecure, String requestPath, int recoveryBufferSize, int maximumQueueSize) {
        this.theConnectionTimeout = connectionTimeout;
        this.theWriteTimeout = writeTimeout;
        this.theInputBufferSize = inputBufferSize;
        this.theOutputBufferSize = outputBufferSize;
        this.theMaximumMessageSize = maximumMessageSize;
        this.theInitialRetryStrategy = initialRetryStrategy;
        this.reconnectionStrategy = reconnectionStrategy;
        this.reconnectionTimeout = reconnectionTimeout;
        this.theLocalSocketAddress = localSocketAddress;
        this.theSSLContext = sslContext;
        this.theProxyAuth = proxyAuth;
        this.theProxyHost = proxyHost;
        this.theProxyPort = proxyPort;
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.requestedTransports = requestedTransports;
        this.isSecure = isSecure;
        this.requestPath = requestPath;
        this.recoveryBufferSize = recoveryBufferSize;
        this.theMaximumQueueSize = maximumQueueSize;
    }

    public SessionAttributesBuilder connectionTimeout(int timeout) throws IllegalArgumentException {
        if (timeout < 1) {
            throw new IllegalArgumentException("Invalid timeout");
        }
        return new SessionAttributesBuilder(LimitTimeouts.limitTimeout("connection timeout", timeout), this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, this.theInitialRetryStrategy, this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, this.theSSLContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, this.serverPort, this.requestedTransports, this.isSecure, this.requestPath, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    public SessionAttributesBuilder inputBufferSize(int size) throws IllegalArgumentException {
        if (size < 1024) {
            throw new IllegalArgumentException("Invalid size");
        }
        return new SessionAttributesBuilder(this.theConnectionTimeout, this.theWriteTimeout, size, this.theOutputBufferSize, this.theMaximumMessageSize, this.theInitialRetryStrategy, this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, this.theSSLContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, this.serverPort, this.requestedTransports, this.isSecure, this.requestPath, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    public SessionAttributesBuilder outputBufferSize(int size) throws IllegalArgumentException {
        if (size < 1024) {
            throw new IllegalArgumentException("Invalid size");
        }
        return new SessionAttributesBuilder(this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, size, this.theMaximumMessageSize, this.theInitialRetryStrategy, this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, this.theSSLContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, this.serverPort, this.requestedTransports, this.isSecure, this.requestPath, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    public SessionAttributesBuilder localSocketAddress(SocketAddress address) {
        return new SessionAttributesBuilder(this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, this.theInitialRetryStrategy, this.reconnectionTimeout, this.reconnectionStrategy, address, this.theSSLContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, this.serverPort, this.requestedTransports, this.isSecure, this.requestPath, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    public SessionAttributesBuilder sslContext(SSLContext context) {
        return new SessionAttributesBuilder(this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, this.theInitialRetryStrategy, this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, Objects.requireNonNull(context, "context is null"), this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, this.serverPort, this.requestedTransports, this.isSecure, this.requestPath, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    public SessionAttributesBuilder writeTimeout(int timeout) throws IllegalArgumentException {
        if (timeout < 1) {
            throw new IllegalArgumentException("Invalid timeout");
        }
        return new SessionAttributesBuilder(this.theConnectionTimeout, LimitTimeouts.limitTimeout("write timeout", timeout), this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, this.theInitialRetryStrategy, this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, this.theSSLContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, this.serverPort, this.requestedTransports, this.isSecure, this.requestPath, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    public SessionAttributesBuilder maximumMessageSize(int size) throws IllegalArgumentException {
        if (size < 1024) {
            throw new IllegalArgumentException("Invalid size");
        }
        return new SessionAttributesBuilder(this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, size, this.theInitialRetryStrategy, this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, this.theSSLContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, this.serverPort, this.requestedTransports, this.isSecure, this.requestPath, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    public SessionAttributesBuilder reconnectionStrategy(ReconnectionStrategy strategy) {
        return new SessionAttributesBuilder(this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, this.theInitialRetryStrategy, this.reconnectionTimeout, Objects.requireNonNull(strategy, "strategy is null"), this.theLocalSocketAddress, this.theSSLContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, this.serverPort, this.requestedTransports, this.isSecure, this.requestPath, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    public SessionAttributesBuilder initialRetryStrategy(RetryStrategy retryStrategy) throws IllegalArgumentException {
        return new SessionAttributesBuilder(this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, retryStrategy, this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, this.theSSLContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, this.serverPort, this.requestedTransports, this.isSecure, this.requestPath, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    private RetryStrategy getInitialRetryStrategy() {
        return this.theInitialRetryStrategy == null ? RetryStrategy.NO_RETRY : this.theInitialRetryStrategy;
    }

    public SessionAttributesBuilder reconnectionTimeout(int timeout) throws IllegalArgumentException {
        return new SessionAttributesBuilder(this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, this.theInitialRetryStrategy, timeout, this.reconnectionStrategy, this.theLocalSocketAddress, this.theSSLContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, this.serverPort, this.requestedTransports, this.isSecure, this.requestPath, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    public SessionAttributesBuilder httpProxy(String host, int port) throws IllegalArgumentException {
        return this.httpProxy(host, port, NullHTTPProxyAuthentication.INSTANCE);
    }

    public SessionAttributesBuilder httpProxy(String host, int port, HTTPProxyAuthentication auth) throws IllegalArgumentException {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid proxy port : " + port);
        }
        return new SessionAttributesBuilder(this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, this.theInitialRetryStrategy, this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, this.theSSLContext, auth, Objects.requireNonNull(host), port, this.serverHost, this.serverPort, this.requestedTransports, this.isSecure, this.requestPath, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    public SessionAttributesBuilder serverHost(String host) {
        return new SessionAttributesBuilder(this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, this.theInitialRetryStrategy, this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, this.theSSLContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, Objects.requireNonNull(host, "host is null"), this.serverPort, this.requestedTransports, this.isSecure, this.requestPath, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    public SessionAttributesBuilder serverPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid server port : " + port);
        }
        return new SessionAttributesBuilder(this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, this.theInitialRetryStrategy, this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, this.theSSLContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, port, this.requestedTransports, this.isSecure, this.requestPath, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    public SessionAttributesBuilder requestedTransports(SessionAttributes.Transport ... transports) {
        Objects.requireNonNull(transports, "transports is null");
        if (transports.length <= 0) {
            throw new IllegalArgumentException("No transports requested");
        }
        List<SessionAttributes.Transport> transportList = Arrays.asList(transports);
        if (transportList.contains(null)) {
            throw new NullPointerException("The requested transports include null");
        }
        return new SessionAttributesBuilder(this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, this.theInitialRetryStrategy, this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, this.theSSLContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, this.serverPort, transportList, this.isSecure, this.requestPath, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    public SessionAttributesBuilder secureTransport(boolean secure) {
        return new SessionAttributesBuilder(this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, this.theInitialRetryStrategy, this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, this.theSSLContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, this.serverPort, this.requestedTransports, secure, this.requestPath, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    public SessionAttributesBuilder requestPath(String path) {
        Objects.requireNonNull(path, "path is null");
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The request path must begin with '/'");
        }
        if (!path.endsWith("/diffusion")) {
            throw new IllegalArgumentException("The request path must end with '/diffusion'");
        }
        return new SessionAttributesBuilder(this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, this.theInitialRetryStrategy, this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, this.theSSLContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, this.serverPort, this.requestedTransports, this.isSecure, path, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    public SessionAttributesBuilder recoveryBufferSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("The recovery buffer size cannot be negative [" + size + "]");
        }
        return new SessionAttributesBuilder(this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, this.theInitialRetryStrategy, this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, this.theSSLContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, this.serverPort, this.requestedTransports, this.isSecure, this.requestPath, size, this.theMaximumQueueSize);
    }

    public SessionAttributesBuilder maximumQueueSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("The maximum queue size must be positive [" + size + "]");
        }
        return new SessionAttributesBuilder(this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, this.theInitialRetryStrategy, this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, this.theSSLContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, this.serverPort, this.requestedTransports, this.isSecure, this.requestPath, this.recoveryBufferSize, size);
    }

    public SessionAttributes build(String serverURL) throws IllegalArgumentException, IllegalStateException {
        SSLContext sslContext = this.getSslContext();
        DiffusionURI uri = DiffusionURI.parse(serverURL);
        SessionAttributes.Transport transport = uri.getTransport();
        return new SessionAttributesImpl(Objects.requireNonNull(serverURL, "serverURL is null"), this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, this.getInitialRetryStrategy(), this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, sslContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, uri.getHost(), uri.getPort(), Collections.singletonList(transport), uri.isSecure(), uri.getPath(), this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    public SessionAttributes build() {
        if (this.serverHost == null) {
            throw new IllegalStateException("The server host must be configured or a URI provided");
        }
        int targetServerPort = this.getTargetServerPort();
        SSLContext sslContext = this.getSslContext();
        return new SessionAttributesImpl(this.getDisplayURI(targetServerPort, this.requestPath), this.theConnectionTimeout, this.theWriteTimeout, this.theInputBufferSize, this.theOutputBufferSize, this.theMaximumMessageSize, this.getInitialRetryStrategy(), this.reconnectionTimeout, this.reconnectionStrategy, this.theLocalSocketAddress, sslContext, this.theProxyAuth, this.theProxyHost, this.theProxyPort, this.serverHost, targetServerPort, this.requestedTransports, this.isSecure, this.requestPath, this.recoveryBufferSize, this.theMaximumQueueSize);
    }

    private SSLContext getSslContext() {
        SSLContext sslContext;
        if (this.theSSLContext == null) {
            try {
                sslContext = SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IllegalStateException("Unable to get default SSL context", ex);
            }
        } else {
            sslContext = this.theSSLContext;
        }
        return sslContext;
    }

    private int getTargetServerPort() {
        return this.serverPort == -1 ? (this.isSecure ? 443 : 80) : this.serverPort;
    }

    private String getDisplayURI(int targetServerPort, String path) {
        SessionAttributes.Transport firstTransport = this.requestedTransports.get(0);
        return ServerDetailsFactory.getURI(this.serverHost, targetServerPort, firstTransport, this.isSecure, path);
    }
}

