/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.session.impl;

import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.SessionEstablishmentException;
import com.pushtechnology.repackaged.picocontainer.Startable;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class OutboundSessions
implements Startable {
    @GuardedBy(value="Content guarded by sessions")
    private final Set<InternalSession> sessions = new HashSet<InternalSession>();
    @GuardedBy(value="Content guarded by sessions")
    private boolean stopped = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(InternalSession session) {
        Set<InternalSession> set = this.sessions;
        synchronized (set) {
            if (this.stopped) {
                session.close();
                throw new SessionEstablishmentException("Global dependencies not started");
            }
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(InternalSession session) {
        Set<InternalSession> set = this.sessions;
        synchronized (set) {
            if (!this.stopped) {
                this.sessions.remove(session);
            }
        }
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Set<InternalSession> set = this.sessions;
        synchronized (set) {
            this.stopped = true;
            for (InternalSession session : this.sessions) {
                session.close();
            }
            this.sessions.clear();
        }
    }
}

