/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.session.impl;

import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import org.slf4j.Logger;

final class ErrorHandlerAdapter
implements InternalSession.InternalErrorHandler {
    private static final Logger LOG = I18nLogger.getLogger(ErrorHandlerAdapter.class);
    private final Session session;
    private final Session.ErrorHandler errorHandler;

    ErrorHandlerAdapter(Session session, Session.ErrorHandler errorHandler) {
        this.session = session;
        this.errorHandler = errorHandler;
    }

    @Override
    public void notifyError(Session.SessionError error) {
        try {
            this.errorHandler.onError(this.session, error);
        }
        catch (Exception t) {
            LOG.error("SESSION_ERROR_HANDLER_EXCEPTION", (Object)this.errorHandler, (Object)t);
        }
        catch (Throwable t) {
            LOG.error("SESSION_ERROR_HANDLER_EXCEPTION", (Object)this.errorHandler, (Object)t);
            throw t;
        }
    }
}

