/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.session;

import com.pushtechnology.diffusion.client.session.Feature;
import com.pushtechnology.diffusion.client.session.SessionAttributes;
import com.pushtechnology.diffusion.client.session.SessionId;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Session
extends AutoCloseable {
    public static final String ANONYMOUS = "";
    public static final String ALL_FIXED_PROPERTIES = "*F";
    public static final String ALL_USER_PROPERTIES = "*U";
    public static final String SESSION_ID = "$SessionId";
    public static final String PRINCIPAL = "$Principal";
    public static final String CONNECTOR = "$Connector";
    public static final String TRANSPORT = "$Transport";
    public static final String CLIENT_TYPE = "$ClientType";
    public static final String COUNTRY = "$Country";
    public static final String LANGUAGE = "$Language";
    public static final String SERVER_NAME = "$ServerName";
    public static final String CLIENT_IP = "$ClientIP";
    public static final String LATITUDE = "$Latitude";
    public static final String LONGITUDE = "$Longitude";
    public static final String START_TIME = "$StartTime";
    public static final String EXPIRY_TIME = "$ExpiryTime";
    public static final String ROLES = "$Roles";
    public static final String MQTT_CLIENT_ID = "$MQTTClientId";
    public static final String GATEWAY_TYPE = "$GatewayType";
    public static final String GATEWAY_ID = "$GatewayId";
    public static final String ENVIRONMENT = "$Environment";

    public SessionId getSessionId();

    public String getPrincipal();

    public SessionAttributes getAttributes();

    public State getState();

    @Override
    public void close();

    public <T extends Feature> T feature(Class<T> var1) throws IllegalArgumentException, UnsupportedOperationException;

    public void addListener(Listener var1);

    public void removeListener(Listener var1);

    public CompletableFuture<Map<String, String>> getSessionProperties();

    public CompletableFuture<SessionLock> lock(String var1);

    public CompletableFuture<SessionLock> lock(String var1, SessionLockScope var2);

    public static enum State {
        CONNECTING(false, false, false),
        CONNECTED_ACTIVE(true, false, false),
        RECOVERING_RECONNECT(false, true, false),
        CLOSED_BY_CLIENT(false, false, true),
        CLOSED_BY_SERVER(false, false, true),
        CLOSED_FAILED(false, false, true);

        private final boolean thisIsConnected;
        private final boolean thisIsRecovering;
        private final boolean thisIsClosed;

        private State(boolean connected, boolean recovering, boolean closed) {
            this.thisIsConnected = connected;
            this.thisIsRecovering = recovering;
            this.thisIsClosed = closed;
        }

        public boolean isConnected() {
            return this.thisIsConnected;
        }

        public boolean isRecovering() {
            return this.thisIsRecovering;
        }

        public boolean isClosed() {
            return this.thisIsClosed;
        }
    }

    public static interface SessionError {
        public String getMessage();

        public String toString();
    }

    public static interface ErrorHandler {
        public void onError(Session var1, SessionError var2);

        public static class Default
        implements ErrorHandler {
            private static final Logger LOG = LoggerFactory.getLogger(Default.class);

            @Override
            public void onError(Session session, SessionError error) {
                LOG.error("{} - An error occurred for session {}: {}", this, session, error);
            }
        }
    }

    public static interface Listener {
        public void onSessionStateChanged(Session var1, State var2, State var3);

        public static class Default
        implements Listener {
            private static final Logger LOG = LoggerFactory.getLogger(Default.class);

            @Override
            public void onSessionStateChanged(Session session, State oldState, State newState) {
                LOG.debug("{} - Session {} state changed from {} to {}", new Object[]{this, session, oldState, newState});
            }
        }
    }

    public static interface SessionLock {
        public String getName();

        public long getSequence();

        public boolean isOwned();

        public SessionLockScope getScope();

        public CompletableFuture<Boolean> unlock();
    }

    public static enum SessionLockScope {
        UNLOCK_ON_CONNECTION_LOSS,
        UNLOCK_ON_SESSION_LOSS;

    }
}

