/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.internal.streams;

import com.pushtechnology.diffusion.client.features.Messaging;
import com.pushtechnology.diffusion.datatype.DataType;
import net.jcip.annotations.Immutable;

@Immutable
public final class RequestStreamParameters<T, R> {
    private final Class<? extends T> requestType;
    private final DataType<? super R> responseDataType;
    private final Messaging.RequestStream<T, R> requestStream;

    public RequestStreamParameters(Class<? extends T> requestType, DataType<? super R> responseDataType, Messaging.RequestStream<T, R> requestStream) {
        this.requestType = requestType;
        this.responseDataType = responseDataType;
        this.requestStream = requestStream;
    }

    public Class<? extends T> getRequestType() {
        return this.requestType;
    }

    public DataType<? super R> getResponseDataType() {
        return this.responseDataType;
    }

    public Messaging.RequestStream<T, R> getRequestStream() {
        return this.requestStream;
    }

    public int hashCode() {
        int result = this.requestType.hashCode();
        result = 31 * result + this.responseDataType.hashCode();
        result = 31 * result + this.requestStream.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestStreamParameters)) {
            return false;
        }
        RequestStreamParameters other = (RequestStreamParameters)o;
        return this.requestType.equals(other.requestType) && this.responseDataType == other.responseDataType && this.requestStream.equals(other.requestStream);
    }

    public String toString() {
        return String.format("%s[%s, %s, %s]", this.getClass().getSimpleName(), this.requestType, this.responseDataType, this.requestStream);
    }
}

