/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.internal.session;

import com.pushtechnology.diffusion.client.internal.session.ClosedSessionListener;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.internal.session.SessionConversationSetFactory;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.session.SessionClosedException;
import com.pushtechnology.diffusion.conversation.ConversationSet;
import com.pushtechnology.diffusion.flowcontrol.ConversationSetFlowMeasurement;
import com.pushtechnology.diffusion.utils.listener.COWListListenerSupport;
import com.pushtechnology.diffusion.utils.listener.ListenerSupport;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractInternalSession
implements InternalSession {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInternalSession.class);
    private final ConversationSetFlowMeasurement conversationFlowMeasurement;
    private final SessionConversationSetFactory conversationSetFactory;
    private volatile ConversationSet conversations;
    private final ListenerSupport<InternalSession.InternalSessionListener> listenerSupport = new COWListListenerSupport<InternalSession.InternalSessionListener>();
    private final AtomicReference<Session.State> state = new AtomicReference<Session.State>(Session.State.CONNECTING);
    private final AtomicReference<InternalSession.InternalErrorHandler> errorHandler = new AtomicReference();
    private volatile String principal;

    protected AbstractInternalSession(SessionConversationSetFactory conversationSetFactory, ConversationSet conversations, ConversationSetFlowMeasurement conversationFlowMeasurement) {
        this.conversationSetFactory = conversationSetFactory;
        this.conversations = conversations;
        this.conversationFlowMeasurement = conversationFlowMeasurement;
        this.addListener(new ClosedSessionListener(){

            @Override
            public void onClosed() {
                LOG.trace("Discarding open conversations because of session close");
                AbstractInternalSession.this.getConversations().discardAll(new SessionClosedException());
            }
        });
    }

    @Override
    public final void setErrorHandler(InternalSession.InternalErrorHandler h) {
        this.errorHandler.set(h);
    }

    @Override
    public final InternalSession.InternalErrorHandler getErrorHandler() {
        InternalSession.InternalErrorHandler result = this.errorHandler.get();
        if (result == null) {
            throw new IllegalStateException("Error handler not set");
        }
        return result;
    }

    @Override
    public final String getPrincipal() {
        return this.principal;
    }

    @Override
    public final void setPrincipal(String principal) {
        this.principal = principal;
    }

    @Override
    public final ConversationSet getConversations() {
        return this.conversations;
    }

    @Override
    public final void addListener(InternalSession.InternalSessionListener l) {
        this.listenerSupport.add(l);
    }

    @Override
    public final void removeListener(InternalSession.InternalSessionListener l) {
        this.listenerSupport.remove(l);
    }

    @Override
    public final Session.State getState() {
        return this.state.get();
    }

    @Override
    public final boolean close() {
        return this.setState(Session.State.CLOSED_BY_CLIENT);
    }

    @Override
    public void replaceConversationSet(Throwable reason) {
        ConversationSet newConversations;
        ConversationSet oldConversations = this.conversations;
        this.conversations = newConversations = this.conversationSetFactory.newConversationSet();
        this.conversationFlowMeasurement.setConversationSetToMeasure(newConversations);
        oldConversations.discardAll(reason);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Replaced {} with {} because '{}'", oldConversations, newConversations, reason.getMessage());
        }
    }

    protected final boolean setState(CurrentStateConstraint constraint, Session.State newState) {
        Session.State oldState;
        do {
            if (constraint.acceptable(oldState = this.getState()) && oldState != newState) continue;
            return false;
        } while (!this.state.compareAndSet(oldState, newState));
        LOG.trace("{}: {} -> {}", new Object[]{this, oldState, newState});
        this.informListeners(oldState, newState);
        return true;
    }

    protected final boolean setState(Session.State newState) {
        return this.setState(CurrentStateConstraint.IS_NOT_CLOSED, newState);
    }

    private void informListeners(Session.State oldState, Session.State newState) {
        this.listenerSupport.apply(listener -> listener.onSessionEvent(this, oldState, newState));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CurrentStateConstraint {
        IS_NOT_CLOSED{

            @Override
            boolean acceptable(Session.State oldState) {
                return !oldState.isClosed();
            }
        };


        abstract boolean acceptable(Session.State var1);
    }
}

