/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.internal.services;

import com.pushtechnology.diffusion.client.callbacks.Registration;
import com.pushtechnology.diffusion.client.callbacks.Stream;
import com.pushtechnology.diffusion.client.features.control.clients.ClientControl;
import com.pushtechnology.diffusion.client.internal.services.AbstractRegistration;
import com.pushtechnology.diffusion.client.internal.services.MutableServiceRegistry;
import com.pushtechnology.diffusion.client.internal.services.SessionEventRegistration;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.command.ErrorReasonException;
import com.pushtechnology.diffusion.command.commands.control.client.SessionEventListenerRegistrationRequest;
import com.pushtechnology.diffusion.command.commands.control.client.SessionPropertiesEvent;
import com.pushtechnology.diffusion.command.commands.control.client.SessionPropertiesEventBatch;
import com.pushtechnology.diffusion.command.commands.control.client.SessionPropertiesListenerRegistrationRequest;
import com.pushtechnology.diffusion.command.receiver.AbstractCommandService;
import com.pushtechnology.diffusion.command.receiver.CommandService;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.NoSuchConversationException;
import com.pushtechnology.diffusion.types.ErrorReportList;
import com.pushtechnology.diffusion.util.concurrent.threads.WaitProtectedCompletableFuture;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

@Immutable
public final class SessionEventRegistrationImpl
extends AbstractRegistration
implements SessionEventRegistration {
    public SessionEventRegistrationImpl(InternalSession internalSession, MutableServiceRegistry serviceRegistry) {
        super(internalSession);
        serviceRegistry.add(CommonServices.SESSION_PROPERTIES_EVENT_2, new SessionPropertiesEventService());
    }

    @Override
    public CompletableFuture<Registration> registerSessionEventStream(final ClientControl.SessionEventStream stream, ClientControl.SessionEventParameters parameters) {
        WaitProtectedCompletableFuture<Registration> result = new WaitProtectedCompletableFuture<Registration>();
        InternalSession internalSession = this.getInternalSession();
        ServiceReference<SessionEventListenerRegistrationRequest, ErrorReportList> register = internalSession.getServiceLocator().obtainService(CommonServices.SESSION_EVENT_REGISTRATION);
        ServiceReference<ConversationId, Void> deregister = internalSession.getServiceLocator().obtainService(CommonServices.SESSION_EVENT_DEREGISTRATION);
        ConversationId cid = this.createConversation(new AbstractSessionEventHandler(result, stream){

            @Override
            public void respondToHandler(SessionPropertiesEventBatch batch) {
                for (SessionPropertiesEvent event : batch.getEvents()) {
                    stream.onSessionEvent(event);
                }
            }
        }, cid2 -> deregister.sendCommand((ConversationId)cid2));
        Instant afterTime = parameters.after();
        register.sendCommand(new SessionEventListenerRegistrationRequest(true, parameters.filter(), parameters.properties(), afterTime == null ? 0L : afterTime.toEpochMilli(), cid), new AbstractRegistration.RegistrationWithErrorsReferenceCallback(cid, "Session filter is invalid"));
        return result;
    }

    @Override
    public CompletableFuture<Registration> registerSessionPropertiesStream(final ClientControl.SessionPropertiesStream stream, Set<String> requiredProperties) {
        WaitProtectedCompletableFuture<Registration> result = new WaitProtectedCompletableFuture<Registration>();
        ServiceReference<SessionPropertiesListenerRegistrationRequest, Void> register = this.getInternalSession().getServiceLocator().obtainService(CommonServices.SESSION_PROPERTIES_REGISTRATION_2);
        ConversationId cid = this.createConversation(new AbstractSessionEventHandler(result, stream){

            @Override
            public void respondToHandler(SessionPropertiesEventBatch batch) {
                for (SessionPropertiesEvent event : batch.getEvents()) {
                    switch (event.getType()) {
                        case OPEN: {
                            stream.onSessionOpen(event.sessionId(), event.getNewProperties());
                            break;
                        }
                        case CLOSE: {
                            stream.onSessionClose(event.sessionId(), event.getOldProperties(), event.closeReason());
                            break;
                        }
                        case UPDATE: {
                            stream.onSessionEvent(event.sessionId(), event.getUpdateType(), event.getNewProperties(), event.getOldProperties());
                            break;
                        }
                    }
                }
            }
        }, cid2 -> register.sendCommand(SessionPropertiesListenerRegistrationRequest.createDeregistrationRequest(cid2)));
        register.sendCommand(SessionPropertiesListenerRegistrationRequest.createRegistrationRequest(requiredProperties, cid), new AbstractRegistration.RegistrationReferenceCallback(cid));
        return result;
    }

    private static final class SessionPropertiesEventService
    extends AbstractCommandService<SessionPropertiesEventBatch, Void, InternalSession> {
        private SessionPropertiesEventService() {
        }

        @Override
        public void safeOnRequest(InternalSession internalSession, SessionPropertiesEventBatch request, CommandService.ServiceCallback<Void> callback) throws NoSuchConversationException {
            internalSession.getConversations().respond(request.getContext(), request);
            callback.respond(null);
        }
    }

    private static abstract class AbstractSessionEventHandler
    extends AbstractRegistration.AbstractHandlerAdapter<SessionPropertiesEventBatch> {
        private final Stream stream;

        private AbstractSessionEventHandler(WaitProtectedCompletableFuture<Registration> registrationFuture, Stream listener) {
            super(registrationFuture);
            this.stream = listener;
        }

        @Override
        protected final void reportPostRegistrationError(Throwable reason) {
            this.stream.onError(ErrorReasonException.localExceptionToErrorReason(reason));
        }

        @Override
        public final void closeHandler() {
            this.stream.onClose();
        }

        public final String toString() {
            return this.stream.toString();
        }
    }
}

