/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.internal.services;

import com.pushtechnology.diffusion.client.internal.services.MutableServiceRegistry;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.command.receiver.CommandService;
import com.pushtechnology.diffusion.command.receiver.LoggingCommandService;
import com.pushtechnology.diffusion.command.services.ServiceDefinition;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class ServiceRegistryImpl
implements MutableServiceRegistry {
    private final ConcurrentMap<Integer, CommandService<?, ?, InternalSession>> services = new ConcurrentHashMap();

    @Override
    public <C, R> void add(ServiceDefinition<C, R> definition, CommandService<C, R, InternalSession> service) {
        LoggingCommandService<C, R, InternalSession> wrappedService = LoggingCommandService.create(service);
        CommandService existingService = this.services.putIfAbsent(definition.getID(), wrappedService);
        if (existingService != null) {
            throw new IllegalStateException("Existing implementation registered for " + String.valueOf(definition) + " [" + String.valueOf(this.services.get(definition.getID())) + "]");
        }
    }

    @Override
    public CommandService<?, ?, InternalSession> get(int serviceId) {
        return (CommandService)this.services.get(serviceId);
    }

    int size() {
        return this.services.size();
    }
}

