/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.internal.services;

import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.callbacks.Registration;
import com.pushtechnology.diffusion.client.features.Messaging;
import com.pushtechnology.diffusion.client.internal.services.AbstractRegistration;
import com.pushtechnology.diffusion.client.internal.services.MutableServiceRegistry;
import com.pushtechnology.diffusion.client.internal.services.RequestReceiverRegistration;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.SessionId;
import com.pushtechnology.diffusion.command.ErrorReasonException;
import com.pushtechnology.diffusion.command.commands.control.client.MessagingClientForwardSendRequest;
import com.pushtechnology.diffusion.command.commands.control.client.MessagingResponse;
import com.pushtechnology.diffusion.command.receiver.AbstractCommandService;
import com.pushtechnology.diffusion.command.receiver.CommandService;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.control.ControlGroup;
import com.pushtechnology.diffusion.control.registration.MessageReceiverControlRegistrationParameters;
import com.pushtechnology.diffusion.control.registration.MessageReceiverControlRegistrationRequest;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.NoSuchConversationException;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.datatype.InvalidDataException;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.logs.i18n.I18nUtils;
import com.pushtechnology.diffusion.util.concurrent.threads.WaitProtectedCompletableFuture;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

@Immutable
public final class RequestReceiverRegistrationImpl
extends AbstractRegistration
implements RequestReceiverRegistration {
    private final DataTypes dataTypes;

    public RequestReceiverRegistrationImpl(DataTypes dataTypes, InternalSession session, MutableServiceRegistry services) {
        super(session);
        this.dataTypes = dataTypes;
        services.add(CommonServices.MESSAGING_RECEIVER_CLIENT, new RequestReceiverService());
    }

    @Override
    public <T, R> CompletableFuture<Registration> registerRequestReceiver(String topicPath, Class<? extends T> requestType, Class<? super R> responseType, Messaging.RequestHandler<T, R> requestHandler, List<String> sessionProperties) {
        DataType<? super R> responseDataType = this.dataTypes.getByClass(responseType);
        WaitProtectedCompletableFuture<Registration> result = new WaitProtectedCompletableFuture<Registration>();
        this.registerHandler(new MessageReceiverControlRegistrationParameters(CommonServices.MESSAGING_RECEIVER_CLIENT, ControlGroup.DEFAULT, topicPath, sessionProperties), new RequestReceiverAdapter<T, R>(result, requestType, responseDataType, requestHandler));
        return result;
    }

    private void registerHandler(MessageReceiverControlRegistrationParameters parameters, AbstractRegistration.HandlerAdapter<Response> apiAdapter) {
        InternalSession internalSession = this.getInternalSession();
        ServiceReference<MessageReceiverControlRegistrationRequest, Void> registration = internalSession.getServiceLocator().obtainService(CommonServices.MESSAGING_RECEIVER_CONTROL_REGISTRATION);
        ServiceReference<MessageReceiverControlRegistrationParameters, Void> deregistration = internalSession.getServiceLocator().obtainService(CommonServices.MESSAGING_RECEIVER_CONTROL_DEREGISTRATION);
        ConversationId cid = this.createConversation(apiAdapter, ignored -> deregistration.sendCommand(parameters));
        registration.sendCommand(new MessageReceiverControlRegistrationRequest(parameters, cid), new AbstractRegistration.RegistrationReferenceCallback(cid));
    }

    private static final class RequestReceiverService
    extends AbstractCommandService<MessagingClientForwardSendRequest, MessagingResponse, InternalSession> {
        private RequestReceiverService() {
        }

        @Override
        protected void safeOnRequest(InternalSession session, MessagingClientForwardSendRequest request, CommandService.ServiceCallback<MessagingResponse> callback) throws NoSuchConversationException {
            session.getConversations().respond(request.getContext(), new Response(request, callback));
        }
    }

    private static final class RequestReceiverAdapter<T, R>
    extends AbstractRegistration.AbstractHandlerAdapter<Response> {
        private static final I18nLogger LOG = I18nLogger.getLogger(RequestReceiverAdapter.class);
        private final Class<? extends T> requestType;
        private final DataType<? super R> responseDataType;
        private final Messaging.RequestHandler<T, R> requestHandler;

        private RequestReceiverAdapter(WaitProtectedCompletableFuture<Registration> registrationFuture, Class<? extends T> requestType, DataType<? super R> responseDataType, Messaging.RequestHandler<T, R> requestHandler) {
            super(registrationFuture);
            this.requestType = requestType;
            this.responseDataType = responseDataType;
            this.requestHandler = requestHandler;
        }

        @Override
        public void respondToHandler(Response response) {
            MessagingClientForwardSendRequest req = response.getRequest();
            CommandService.ServiceCallback<MessagingResponse> callback = response.getCallback();
            ResponderImpl<? super R> responder = new ResponderImpl<R>(callback, this.responseDataType);
            DataType<?> dataType = req.getDataType();
            if (dataType.canReadAs(this.requestType)) {
                T requestData;
                try {
                    requestData = dataType.readAs(this.requestType, req.getRequest());
                }
                catch (InvalidDataException ex) {
                    I18nLogger.Translation translation = I18nUtils.formatMessage("MESSAGING_REQUEST_CANNOT_CONVERT_VALUE", this.requestType, req.getPath(), this.requestHandler);
                    LOG.error(translation, (Throwable)ex);
                    callback.fail(ErrorReason.INVALID_DATA, translation.getText());
                    return;
                }
                this.requestHandler.onRequest(requestData, new RequestContextImpl(req.getSessionId(), req.getPath(), req.getSessionProperties()), responder);
            } else {
                I18nLogger.Translation translation = I18nUtils.formatMessage("MESSAGING_REQUEST_INCOMPATIBLE", dataType, req.getPath(), this.requestHandler);
                LOG.debug(translation);
                callback.fail(ErrorReason.INCOMPATIBLE_DATATYPE, translation.getText());
            }
        }

        @Override
        public void closeHandler() {
            this.requestHandler.onClose();
        }

        @Override
        protected void reportPostRegistrationError(Throwable reason) {
            this.requestHandler.onError(ErrorReasonException.localExceptionToErrorReason(reason));
        }
    }

    private static final class Response
    extends AbstractRegistration.ServiceCallbackResponse<MessagingResponse> {
        private final MessagingClientForwardSendRequest request;

        Response(MessagingClientForwardSendRequest request, CommandService.ServiceCallback<MessagingResponse> callback) {
            super(callback);
            this.request = request;
        }

        MessagingClientForwardSendRequest getRequest() {
            return this.request;
        }
    }

    private static final class RequestContextImpl
    implements Messaging.RequestHandler.RequestContext {
        private final SessionId sessionId;
        private final String path;
        private final Map<String, String> sessionProperties;

        RequestContextImpl(SessionId sessionId, String path, Map<String, String> sessionProperties) {
            this.sessionId = sessionId;
            this.path = path;
            this.sessionProperties = sessionProperties;
        }

        @Override
        public SessionId getSessionId() {
            return this.sessionId;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public Map<String, String> getSessionProperties() {
            return Collections.unmodifiableMap(this.sessionProperties);
        }
    }

    private static final class ResponderImpl<R>
    implements Messaging.RequestHandler.Responder<R> {
        private final CommandService.ServiceCallback<MessagingResponse> callback;
        private final DataType<? super R> responseDataType;

        private ResponderImpl(CommandService.ServiceCallback<MessagingResponse> callback, DataType<? super R> responseDataType) {
            this.callback = callback;
            this.responseDataType = responseDataType;
        }

        @Override
        public void respond(R response) {
            IBytes responseData = IBytes.toIBytes(this.responseDataType.toBytes(response));
            MessagingResponse messagingResponse = new MessagingResponse(this.responseDataType, responseData);
            this.callback.respond(messagingResponse);
        }

        @Override
        public void reject(String message) {
            this.callback.fail(ErrorReasonException.REJECTED_REQUEST, message);
        }
    }
}

