/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.internal.routing;

import com.pushtechnology.diffusion.client.internal.routing.StreamProxy;
import com.pushtechnology.diffusion.client.internal.routing.TopicCacheEntryImpl;
import com.pushtechnology.diffusion.client.internal.routing.ValueStreamProxy;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.collections.ImmutableSet;
import com.pushtechnology.diffusion.datatype.BinaryDelta;
import com.pushtechnology.diffusion.datatype.Bytes;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.threads.InboundThreadOnly;

@InboundThreadOnly
final class NoConversionTopicCacheEntry
extends TopicCacheEntryImpl {
    private static boolean isCompatibleStream(StreamProxy streamProxy) {
        if (streamProxy instanceof ValueStreamProxy) {
            return NoConversionTopicCacheEntry.isCompatibleStream((ValueStreamProxy)streamProxy);
        }
        return true;
    }

    private static <V> boolean isCompatibleStream(ValueStreamProxy<V> streamProxy) {
        Class<V> valueClass = streamProxy.getValueClass();
        return Bytes.class.equals(valueClass) || IBytes.class.equals(valueClass);
    }

    NoConversionTopicCacheEntry(String topicPath, TopicSpecification topicSpecification, ImmutableSet<StreamProxy> unfilteredProxies) {
        super(topicPath, topicSpecification, unfilteredProxies.without(s -> !NoConversionTopicCacheEntry.isCompatibleStream(s)));
    }

    @Override
    public void handleValue(DataTypes dataTypes, IBytes data, ImmutableSet<StreamProxy> fallbackStreamProxies) {
        this.notifyValue(dataTypes, null, data, fallbackStreamProxies);
    }

    @Override
    public void handleDelta(DataTypes dataTypes, IBytes data, ImmutableSet<StreamProxy> fallbackStreamProxies) {
        this.notifyDelta(dataTypes, data, null, null, data, fallbackStreamProxies);
    }

    @Override
    protected IBytes currentValue() {
        return null;
    }

    @Override
    protected <V> boolean isCompatibleStream(ValueStreamProxy<V> streamProxy, TopicSpecification specification) {
        return NoConversionTopicCacheEntry.isCompatibleStream(streamProxy);
    }

    @Override
    protected <V> void valueStreamOnValue(DataTypes dataTypes, ValueStreamProxy<V> streamProxy, String path, TopicSpecification specification, IBytes oldValue, IBytes newValue) {
        streamProxy.onValue(path, specification, oldValue, newValue);
    }

    @Override
    protected <V> void valueStreamOnDelta(DataTypes dataTypes, ValueStreamProxy<V> streamProxy, String path, TopicSpecification specification, BinaryDelta delta, IBytes oldValue, IBytes newValue) {
        streamProxy.onDelta(path, specification, delta, oldValue, newValue);
    }
}

