/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.impl;

import com.pushtechnology.diffusion.cache.WeakValueCache;
import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.UpdateConstraint;
import com.pushtechnology.diffusion.client.features.control.Metrics;
import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.client.features.control.clients.ClientControl;
import com.pushtechnology.diffusion.client.features.control.impl.DeprecatedRemoteServerBuilder;
import com.pushtechnology.diffusion.client.features.control.impl.PrimaryInitiatorBuilderImpl;
import com.pushtechnology.diffusion.client.features.control.impl.SecondaryAcceptorBuilderImpl;
import com.pushtechnology.diffusion.client.features.control.impl.SecondaryInitiatorBuilderImpl;
import com.pushtechnology.diffusion.client.features.control.impl.SessionEventParametersBuilder;
import com.pushtechnology.diffusion.client.features.control.topics.SessionTrees;
import com.pushtechnology.diffusion.client.impl.CredentialsFactoryImpl;
import com.pushtechnology.diffusion.client.internal.routing.InternedTopicSpecifications;
import com.pushtechnology.diffusion.client.internal.routing.TopicRoutingImpl;
import com.pushtechnology.diffusion.client.session.SessionFactory;
import com.pushtechnology.diffusion.client.session.SessionId;
import com.pushtechnology.diffusion.client.session.impl.OutboundSessions;
import com.pushtechnology.diffusion.client.session.impl.ProxyAuthenticationFactoryImpl;
import com.pushtechnology.diffusion.client.session.impl.SessionContainerFactoryImpl;
import com.pushtechnology.diffusion.client.session.impl.SessionFactoryImpl;
import com.pushtechnology.diffusion.client.session.proxy.ProxyAuthenticationFactory;
import com.pushtechnology.diffusion.client.topics.TopicSelectors;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.client.topics.impl.TopicSelectorsImpl;
import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.command.client.v4.V4SessionFactory;
import com.pushtechnology.diffusion.comms.connection.CascadeDriverImpl;
import com.pushtechnology.diffusion.comms.connection.NetworkChannelFactoryImpl;
import com.pushtechnology.diffusion.comms.connection.ReverseSecondaryConnectorImpl;
import com.pushtechnology.diffusion.connection.activity.monitor.ConnectionActivityMonitorFactoryImpl;
import com.pushtechnology.diffusion.constraints.ConstraintFactory;
import com.pushtechnology.diffusion.conversation.ConversationSetFactoryImpl;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.datatype.impl.DataTypesImpl;
import com.pushtechnology.diffusion.datatype.impl.TopicTypeToDataType;
import com.pushtechnology.diffusion.flowcontrol.QuadraticBackOffCalculator;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.session.impl.SessionIdImpl;
import com.pushtechnology.diffusion.sessiontrees.BranchMappingTableBuilder;
import com.pushtechnology.diffusion.statistics.metriccollectors.SessionMetricCollectorBuilder;
import com.pushtechnology.diffusion.statistics.metriccollectors.TopicMetricCollectorBuilder;
import com.pushtechnology.diffusion.topics.details.TopicSpecificationImpl;
import com.pushtechnology.diffusion.topics.selectors.TopicSelectorParser;
import com.pushtechnology.diffusion.topics.selectors.TopicSelectorParserImpl;
import com.pushtechnology.diffusion.util.concurrent.scheduled.Periodic;
import com.pushtechnology.diffusion.util.concurrent.scheduled.PeriodicTaskStarter;
import com.pushtechnology.diffusion.utils.PropertyUtils;
import com.pushtechnology.diffusion.utils.classloader.RegisteredImplementations;
import com.pushtechnology.repackaged.picocontainer.ComponentAdapter;
import com.pushtechnology.repackaged.picocontainer.MutablePicoContainer;
import com.pushtechnology.repackaged.picocontainer.PicoBuilder;
import com.pushtechnology.repackaged.picocontainer.parameters.CollectionComponentParameter;
import com.pushtechnology.repackaged.picocontainer.parameters.ComponentParameter;
import com.pushtechnology.repackaged.picocontainer.parameters.ConstantParameter;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;

public final class SessionGlobalsImpl
implements Diffusion.Implementation {
    private static final Logger LOG = I18nLogger.getLogger(SessionGlobalsImpl.class);
    private final SessionFactory sessionFactory;
    @GuardedBy(value="dependencies")
    private boolean requiresStart;
    private final MutablePicoContainer dependencies;

    private SessionGlobalsImpl(MutablePicoContainer globalContainer, Consumer<MutablePicoContainer> configureExtraSessionComponents, boolean requiresStart) {
        this.requiresStart = requiresStart;
        SessionContainerFactoryImpl sessionContainerFactory = new SessionContainerFactoryImpl(globalContainer, configureExtraSessionComponents);
        this.dependencies = globalContainer.addComponent(NetworkChannelFactoryImpl.class).addComponent(CascadeDriverImpl.class).addComponent(ReverseSecondaryConnectorImpl.class).addComponent(ConnectionActivityMonitorFactoryImpl.class).addComponent(ConversationSetFactoryImpl.class).addComponent(ConstraintFactory.class).addComponent(CredentialsFactoryImpl.class).addComponent(DataTypesImpl.class).addComponent(PeriodicTaskStarter.class, PeriodicTaskStarter.class, ComponentParameter.DEFAULT, new CollectionComponentParameter(Periodic.class, false)).addComponent(ProxyAuthenticationFactoryImpl.class).addComponent(QuadraticBackOffCalculator.class).addComponent(new OutboundSessions()).addComponent(sessionContainerFactory).addComponent(TopicSelectorsImpl.class).addComponent(TopicTypeToDataType.class).addComponent(V4SessionFactory.class).addComponent("ts-cache", WeakValueCache.class, new ConstantParameter(30000L)).addComponent(InternedTopicSpecifications.class);
        if (this.dependencies.getComponentAdapters(TopicSelectorParser.class).isEmpty()) {
            globalContainer.addComponent(TopicSelectorParser.class, TopicSelectorParserImpl.class, new ComponentParameter("ts-cache"));
        }
        this.sessionFactory = new SessionFactoryImpl(globalContainer, sessionContainerFactory, this.getCredentialsFactory());
    }

    MutablePicoContainer getContainer() {
        return this.dependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requireServices() {
        MutablePicoContainer mutablePicoContainer = this.dependencies;
        synchronized (mutablePicoContainer) {
            if (this.requiresStart) {
                this.requiresStart = false;
                this.dependencies.start();
            }
        }
    }

    public static SessionGlobalsImpl createClientSessionGlobals() {
        return SessionGlobalsImpl.createClientSessionGlobals(SessionGlobalsImpl.loadExtraSessionComponents(), "com/pushtechnology/diffusion/client/impl/global-components");
    }

    static SessionGlobalsImpl createClientSessionGlobals(List<Class<?>> extraSessionComponents, String globalComponents) {
        List<Class<?>> components = SessionGlobalsImpl.loadComponents(globalComponents);
        if (components.isEmpty()) {
            throw new IllegalStateException("Client API components have not been loaded.");
        }
        MutablePicoContainer dependencies = new PicoBuilder().withCaching().withConstructorInjection().withLifecycle().withLocking().build();
        for (Class<?> feature : components) {
            if (ComponentAdapter.class.isAssignableFrom(feature)) {
                try {
                    dependencies.addAdapter((ComponentAdapter)feature.newInstance());
                    continue;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new AssertionError((Object)e);
                }
            }
            dependencies.addComponent(feature);
        }
        return new SessionGlobalsImpl(dependencies, sessionContainer -> {
            for (Object c : extraSessionComponents) {
                sessionContainer.addComponent(c);
            }
            sessionContainer.addComponent(TopicRoutingImpl.class);
        }, true);
    }

    public static SessionGlobalsImpl createServerSessionGlobals(MutablePicoContainer globalDependencies, Consumer<MutablePicoContainer> configureExtraSessionComponents) {
        List<Class<?>> extraSessionComponents = SessionGlobalsImpl.loadExtraSessionComponents();
        return new SessionGlobalsImpl(globalDependencies, sessionContainer -> {
            for (Object c : extraSessionComponents) {
                sessionContainer.addComponent(c);
            }
            configureExtraSessionComponents.accept((MutablePicoContainer)sessionContainer);
        }, false);
    }

    public static Diffusion.Implementation stubSessionGlobals() {
        return new SessionGlobalsImpl(new PicoBuilder().build(), c -> {}, false);
    }

    private static List<Class<?>> loadExtraSessionComponents() {
        return SessionGlobalsImpl.loadComponents("com/pushtechnology/diffusion/client/impl/session-components");
    }

    private static List<Class<?>> loadComponents(String resourceName) {
        try {
            List<Class<?>> result = RegisteredImplementations.loadRegisteredImplementations(resourceName, Object.class, SessionGlobalsImpl.class.getClassLoader());
            LOG.trace("Resolved components from {}: {}", (Object)resourceName, (Object)result);
            return result;
        }
        catch (RegisteredImplementations.RegistrationException e) {
            LOG.error("CLIENT_INITIALISATION_ERROR", e);
            throw e;
        }
    }

    @Override
    public SessionFactory getSessionFactory() {
        this.requireServices();
        return this.sessionFactory;
    }

    @Override
    public Credentials.Factory getCredentialsFactory() {
        return this.dependencies.getComponent(Credentials.Factory.class);
    }

    @Override
    public TopicSelectors getTopicSelectors() {
        this.requireServices();
        return this.dependencies.getComponent(TopicSelectors.class);
    }

    @Override
    public ProxyAuthenticationFactory getProxyAuthenticationFactory() {
        return this.dependencies.getComponent(ProxyAuthenticationFactory.class);
    }

    @Override
    public DataTypes getDataTypes() {
        return this.dependencies.getComponent(DataTypes.class);
    }

    @Override
    public TopicSpecification newTopicSpecification(TopicType topicType) {
        return new TopicSpecificationImpl(topicType);
    }

    @Override
    public UpdateConstraint.Factory updateConstraints() {
        return this.dependencies.getComponent(UpdateConstraint.Factory.class);
    }

    @Override
    public Set<String> stringToRoles(String string) {
        return new HashSet<String>(PropertyUtils.stringToSet(Objects.requireNonNull(string, "string is null")));
    }

    @Override
    public String rolesToString(Set<String> roles) {
        return PropertyUtils.setToString(Objects.requireNonNull(roles, "roles is null"));
    }

    @Override
    public String escape(String string) {
        return PropertyUtils.escape(Objects.requireNonNull(string, "string is null"));
    }

    @Override
    public SessionTrees.BranchMappingTable.Builder newBranchMappingTableBuilder() {
        return new BranchMappingTableBuilder();
    }

    @Override
    public Metrics.SessionMetricCollector.Builder newSessionMetricCollectorBuilder() {
        return new SessionMetricCollectorBuilder();
    }

    @Override
    public Metrics.TopicMetricCollector.Builder newTopicMetricCollectorBuilder() {
        return new TopicMetricCollectorBuilder(this.getTopicSelectors());
    }

    @Override
    public RemoteServers.RemoteServer.Builder newRemoteServerBuilder() {
        return new DeprecatedRemoteServerBuilder(this.getTopicSelectors());
    }

    @Override
    public ClientControl.SessionEventParameters.Builder newSessionEventParametersBuilder() {
        return new SessionEventParametersBuilder();
    }

    @Override
    public <B extends RemoteServers.RemoteServer.RemoteServerBuilder<B>> B newRemoteServerBuilder(Class<B> builderInterface) throws IllegalArgumentException {
        Objects.requireNonNull(builderInterface, "builderInterface is null");
        if (RemoteServers.SecondaryInitiator.SecondaryInitiatorBuilder.class.isAssignableFrom(builderInterface)) {
            return (B)new SecondaryInitiatorBuilderImpl(this.getTopicSelectors());
        }
        if (RemoteServers.PrimaryInitiator.PrimaryInitiatorBuilder.class.isAssignableFrom(builderInterface)) {
            return (B)new PrimaryInitiatorBuilderImpl();
        }
        if (RemoteServers.SecondaryAcceptor.SecondaryAcceptorBuilder.class.isAssignableFrom(builderInterface)) {
            return (B)new SecondaryAcceptorBuilderImpl(this.getTopicSelectors());
        }
        throw new IllegalArgumentException(builderInterface.getSimpleName() + " is not a supported Federation builder interface");
    }

    @Override
    public SessionId sessionIdFromString(String sessionIdAsString) throws IllegalArgumentException {
        return SessionIdImpl.parseString(Objects.requireNonNull(sessionIdAsString, "sessionIdAsString is null"));
    }
}

