/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.impl;

import com.pushtechnology.diffusion.api.internal.connection.DiffusionURI;
import com.pushtechnology.diffusion.api.internal.connection.InternalConnectionType;
import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.session.AuthenticationException;
import com.pushtechnology.diffusion.client.session.SessionFactory;
import com.pushtechnology.diffusion.client.session.impl.ExtendedSessionFactory;
import com.pushtechnology.diffusion.command.commands.gateway.operations.GatewayOperation;
import com.pushtechnology.diffusion.command.commands.gateway.operations.GatewayOperationDetail;
import com.pushtechnology.diffusion.command.commands.gateway.services.GatewayServiceDetail;
import com.pushtechnology.diffusion.command.commands.gateway.services.GatewayServiceId;
import com.pushtechnology.diffusion.command.commands.gateway.services.GatewayServiceType;
import com.pushtechnology.diffusion.command.commands.gateway.status.GatewayStatusItem;
import com.pushtechnology.diffusion.datatype.internal.JacksonContext;
import com.pushtechnology.diffusion.gateway.DiffusionGateway;
import com.pushtechnology.diffusion.gateway.Gateway;
import com.pushtechnology.diffusion.gateway.GatewayService;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.repackaged.jackson.core.JsonParser;
import com.pushtechnology.repackaged.jackson.core.JsonToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class GatewayImplementation
implements DiffusionGateway.Implementation {
    private static final String OAUTH_RESPONSE_ACCESS_TOKEN_FIELD = "access_token";
    private static final int OAUTH_TIMEOUT = 30000;
    public static final String SERVER_URL_SYSTEM_PROPERTY = "diffusion.gateway.server.url";
    static final String PRINCIPAL_SYSTEM_PROPERTY = "diffusion.gateway.principal";
    static final String PASSWORD_SYSTEM_PROPERTY = "diffusion.gateway.password";
    static final String OAUTH_SERVER_SYSTEM_PROPERTY = "diffusion.gateway.oauth.server";
    static final String OAUTH_HEADERS_SYSTEM_PROPERTY = "diffusion.gateway.oauth.headers";
    static final String OAUTH_METHOD_SYSTEM_PROPERTY = "diffusion.gateway.oauth.method";
    static final String OAUTH_PAYLOAD_SYSTEM_PROPERTY = "diffusion.gateway.oauth.payload";
    private final OAuthConnector theOAuthConnector;

    public GatewayImplementation() {
        this(new OAuthConnectorImpl());
    }

    GatewayImplementation(OAuthConnector oAuthConnector) {
        this.theOAuthConnector = oAuthConnector;
    }

    @Override
    public SessionFactory newSessionFactory(String gatewayType, String gatewayId) {
        String type = Objects.requireNonNull(gatewayType, "gatewayType is null");
        String id = Objects.requireNonNull(gatewayId, "gatewayId is null");
        String oAuthToken = this.getOAuthToken();
        SessionFactory sessionFactory = ((ExtendedSessionFactory)Diffusion.sessions()).requestedConnectionType(InternalConnectionType.WEBSOCKET_JAVA_GATEWAY_CLIENT).property("$GatewayType", type).property("$GatewayId", id).maximumQueueSize(10000).inputBufferSize(524288).outputBufferSize(524288);
        return GatewayImplementation.applyEnvironmentVariables(sessionFactory, oAuthToken);
    }

    private static SessionFactory applyEnvironmentVariables(SessionFactory sessionFactory, String oAuthToken) {
        String principal;
        SessionFactory factory = sessionFactory;
        String url = ConfigurationUtils.getSystemProperty(SERVER_URL_SYSTEM_PROPERTY);
        if (url != null) {
            try {
                DiffusionURI uri = DiffusionURI.parse(url);
                factory = factory.serverHost(uri.getHost());
                factory = factory.serverPort(uri.getPort());
                factory = factory.secureTransport(uri.isSecure());
                factory = factory.requestPath(uri.getPath());
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Gateway server URL is invalid", ex);
            }
        }
        if ((principal = ConfigurationUtils.getSystemProperty(PRINCIPAL_SYSTEM_PROPERTY)) != null) {
            factory = factory.principal(principal);
        }
        if (oAuthToken != null) {
            factory = factory.password(oAuthToken);
        } else {
            String password = ConfigurationUtils.getSystemProperty(PASSWORD_SYSTEM_PROPERTY);
            if (password != null) {
                factory = factory.password(password);
            }
        }
        return factory;
    }

    @Override
    public Gateway.StatusItem newStatusItem(Gateway.StatusItem.Level level, Instant timestamp, String title, String description) {
        return new GatewayStatusItem(Objects.requireNonNull(level, "level is null"), Objects.requireNonNull(timestamp, "timestamp is null"), Objects.requireNonNull(title, "title is null"), Objects.requireNonNull(description, "description is null"));
    }

    @Override
    public Gateway.Operation newOperation(String name, String summary) {
        return new GatewayOperation(Objects.requireNonNull(name, "name is null"), Objects.requireNonNull(summary, "summary is null"));
    }

    @Override
    public Gateway.OperationDetail newOperationDetail(String description, String inputSchema, String outputSchema) {
        return new GatewayOperationDetail(Objects.requireNonNull(description, "description is null"), inputSchema, outputSchema);
    }

    @Override
    public Gateway.ServiceType newServiceType(String name, String description, String schema, boolean sharedConfig) {
        return new GatewayServiceType(Objects.requireNonNull(name, "name is null"), Objects.requireNonNull(description, "description is null"), Objects.requireNonNull(schema, "schema is null"), sharedConfig);
    }

    @Override
    public Gateway.Service newService(String serviceType, String name, String description, String configuration, Gateway.RequestStream requestStream) {
        return new GatewayService(new GatewayServiceDetail(new GatewayServiceId(Objects.requireNonNull(serviceType, "serviceType is null"), Objects.requireNonNull(name, "name is null")), Objects.requireNonNull(description, "description is null"), Objects.requireNonNull(configuration, "configuration is null")), Objects.requireNonNull(requestStream, "requestStream is null"));
    }

    private String getOAuthToken() throws AuthenticationException {
        URL url = GatewayImplementation.getOAuthUrl();
        if (url == null) {
            return null;
        }
        String password = ConfigurationUtils.getSystemProperty(PASSWORD_SYSTEM_PROPERTY);
        if (password != null) {
            throw new IllegalArgumentException("Both OAuth details and password have been supplied as system property arguments");
        }
        String method = ConfigurationUtils.getSystemProperty(OAUTH_METHOD_SYSTEM_PROPERTY, "POST");
        Map<String, String> headers = GatewayImplementation.parseOAuthHeaders(ConfigurationUtils.getSystemProperty(OAUTH_HEADERS_SYSTEM_PROPERTY, ""));
        String payload = ConfigurationUtils.getSystemProperty(OAUTH_PAYLOAD_SYSTEM_PROPERTY, "");
        try {
            return this.theOAuthConnector.getToken(url, method, headers, payload);
        }
        catch (IOException ex) {
            throw new AuthenticationException("Unable to obtain OAuth access token", ex);
        }
    }

    private static Map<String, String> parseOAuthHeaders(String json) {
        try {
            JsonParser parser = JacksonContext.JSON_FACTORY.createParser(json);
            HashMap<String, String> map = new HashMap<String, String>();
            JsonToken t = parser.nextToken();
            if (t == JsonToken.START_OBJECT) {
                t = parser.nextToken();
                while (t != JsonToken.END_OBJECT) {
                    String key;
                    if (t == JsonToken.FIELD_NAME) {
                        key = parser.currentName();
                        t = parser.nextToken();
                        if (t == null || !t.isScalarValue()) {
                            throw new IOException("Map format invalid : Value expected");
                        }
                    } else {
                        throw new IOException("Map format invalid : Key expected");
                    }
                    String value = parser.getValueAsString();
                    map.put(key, value);
                    t = parser.nextToken();
                }
            }
            return map;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Error parsing OAuth headers", ex);
        }
    }

    private static URL getOAuthUrl() {
        String urlString = ConfigurationUtils.getSystemProperty(OAUTH_SERVER_SYSTEM_PROPERTY);
        if (urlString == null) {
            return null;
        }
        if (urlString.isEmpty()) {
            throw new IllegalArgumentException("Empty OAuth server property");
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid OAuth server URL", ex);
        }
    }

    static final class OAuthConnectorImpl
    implements OAuthConnector {
        OAuthConnectorImpl() {
        }

        @Override
        public String getToken(URL url, String method, Map<String, String> headers, String payload) throws IOException {
            String responseString;
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod(method);
            headers.forEach(httpURLConnection::setRequestProperty);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setConnectTimeout(30000);
            httpURLConnection.setReadTimeout(30000);
            byte[] input = payload.getBytes(Charset.defaultCharset());
            try (OutputStream os = httpURLConnection.getOutputStream();){
                os.write(input, 0, input.length);
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), StandardCharsets.UTF_8));){
                StringBuilder response = new StringBuilder();
                String responseLine = br.readLine();
                while (responseLine != null) {
                    response.append(responseLine);
                    responseLine = br.readLine();
                }
                responseString = response.toString();
            }
            JsonParser parser = JacksonContext.JSON_FACTORY.createParser(responseString);
            JsonToken t = parser.nextToken();
            while (t != null) {
                if (t == JsonToken.FIELD_NAME && GatewayImplementation.OAUTH_RESPONSE_ACCESS_TOKEN_FIELD.equals(parser.currentName()) && (t = parser.nextToken()) != null && t.isScalarValue()) {
                    return parser.getValueAsString();
                }
                t = parser.nextToken();
            }
            throw new AuthenticationException("OAuth reply does not contain access_token");
        }
    }

    static interface OAuthConnector {
        public String getToken(URL var1, String var2, Map<String, String> var3, String var4) throws IOException;
    }
}

