/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.impl.update.stream;

import com.pushtechnology.diffusion.client.features.TopicCreationResult;
import com.pushtechnology.diffusion.client.features.impl.update.stream.InternalUpdateStream;
import com.pushtechnology.diffusion.client.features.impl.update.stream.InvalidUnsetStream;
import com.pushtechnology.diffusion.client.features.impl.update.stream.SetStream;
import com.pushtechnology.diffusion.client.features.impl.update.stream.UpdateStreamImpl;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.topics.update.update.stream.CreateUpdateStreamResponse;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamId;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamRequest;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.jcip.annotations.Immutable;

@Immutable
final class ValidatedStream<T>
implements InternalUpdateStream<T> {
    private final UpdateStreamImpl<T> stream;
    private final CreateUpdateStreamResponse createUpdateStreamResponse;
    private final ServiceReference<UpdateStreamId, Void> validateService;
    private final ServiceReference<UpdateStreamRequest, Void> setService;
    private final ServiceReference<UpdateStreamRequest, Void> updateService;
    private final DataType<T> dataType;
    private final BiFunction<T, T, IBytes> toBytes;

    ValidatedStream(UpdateStreamImpl<T> stream, CreateUpdateStreamResponse createUpdateStreamResponse, ServiceReference<UpdateStreamId, Void> validateService, ServiceReference<UpdateStreamRequest, Void> setService, ServiceReference<UpdateStreamRequest, Void> updateService, DataType<T> dataType, BiFunction<T, T, IBytes> toBytes) {
        this.stream = stream;
        this.createUpdateStreamResponse = createUpdateStreamResponse;
        this.validateService = validateService;
        this.setService = setService;
        this.updateService = updateService;
        this.dataType = dataType;
        this.toBytes = toBytes;
    }

    @Override
    public T get() {
        throw new IllegalStateException("The set method has not been called");
    }

    @Override
    public CompletableFuture<TopicCreationResult> set(T value) {
        IBytes bytes = (IBytes)this.dataType.toBytes(value);
        CompletableFuture<Void> serverResponse = this.setService.sendCommand(new UpdateStreamRequest(this.createUpdateStreamResponse.getStreamId(), bytes));
        this.stream.setDelegate(new SetStream<T>(this.stream, this.createUpdateStreamResponse, this.validateService, this.updateService, this.toBytes, value));
        serverResponse.whenComplete((id, ex) -> {
            if (ex != null) {
                this.stream.onSetFailed((Throwable)ex);
            } else {
                this.stream.onSetComplete(this.createUpdateStreamResponse);
            }
        });
        return serverResponse.thenApply(x -> TopicCreationResult.EXISTS);
    }

    @Override
    public boolean onSetComplete(CreateUpdateStreamResponse response) {
        throw new IllegalStateException("The set method has not been called");
    }

    @Override
    public boolean onSetFailed(Throwable ex) {
        throw new IllegalStateException("The set method has not been called");
    }

    @Override
    public CompletableFuture<TopicCreationResult> validate() {
        CompletableFuture<Void> serverResponse = this.validateService.sendCommand(this.createUpdateStreamResponse.getStreamId());
        serverResponse.whenComplete((id, ex) -> {
            if (ex != null) {
                this.stream.onValidateFailed((Throwable)ex);
            } else {
                this.stream.onValidateComplete(this.createUpdateStreamResponse);
            }
        });
        return serverResponse.thenApply(x -> TopicCreationResult.EXISTS);
    }

    @Override
    public boolean onValidateComplete(CreateUpdateStreamResponse response) {
        return true;
    }

    @Override
    public boolean onValidateFailed(Throwable ex) {
        return this.stream.casDelegate(this, new InvalidUnsetStream(ex));
    }
}

