/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.impl.update.stream;

import com.pushtechnology.diffusion.client.features.TopicCreationResult;
import com.pushtechnology.diffusion.client.features.impl.update.stream.InternalUpdateStream;
import com.pushtechnology.diffusion.threads.InboundThreadOnly;
import com.pushtechnology.diffusion.topics.update.update.stream.CreateUpdateStreamResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class UpdateStreamImpl<T>
implements InternalUpdateStream<T> {
    private volatile InternalUpdateStream<T> delegate;

    UpdateStreamImpl(Function<UpdateStreamImpl<T>, InternalUpdateStream<T>> internalStreamFactory) {
        this.delegate = internalStreamFactory.apply(this);
    }

    @Override
    public synchronized CompletableFuture<TopicCreationResult> set(T value) {
        try {
            return this.delegate.set(value);
        }
        catch (IllegalArgumentException e) {
            throw new NullPointerException("null can only be passed for int64, double or string topics");
        }
    }

    @Override
    public synchronized T get() {
        return this.delegate.get();
    }

    @Override
    public synchronized CompletableFuture<TopicCreationResult> validate() {
        return this.delegate.validate();
    }

    @Override
    public boolean onSetComplete(CreateUpdateStreamResponse streamId) {
        while (!this.delegate.onSetComplete(streamId)) {
        }
        return true;
    }

    @Override
    public boolean onSetFailed(Throwable ex) {
        while (!this.delegate.onSetFailed(ex)) {
        }
        return true;
    }

    @Override
    public boolean onValidateComplete(CreateUpdateStreamResponse response) {
        while (!this.delegate.onValidateComplete(response)) {
        }
        return true;
    }

    @Override
    public boolean onValidateFailed(Throwable ex) {
        while (!this.delegate.onValidateFailed(ex)) {
        }
        return true;
    }

    @InboundThreadOnly
    synchronized void setDelegate(InternalUpdateStream<T> newDelegate) {
        this.delegate = newDelegate;
    }

    @InboundThreadOnly
    synchronized boolean casDelegate(InternalUpdateStream<T> oldDelegate, InternalUpdateStream<T> newDelegate) {
        if (this.delegate != oldDelegate) {
            return false;
        }
        this.delegate = newDelegate;
        return true;
    }

    synchronized InternalUpdateStream<T> getDelegate() {
        return this.delegate;
    }
}

