/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.impl.update.stream;

import com.pushtechnology.diffusion.client.features.RecoverableUpdateStream;
import com.pushtechnology.diffusion.client.features.UpdateConstraint;
import com.pushtechnology.diffusion.client.features.UpdateStream;
import com.pushtechnology.diffusion.client.features.impl.update.stream.NewAddAndSetStream;
import com.pushtechnology.diffusion.client.features.impl.update.stream.NewStream;
import com.pushtechnology.diffusion.client.features.impl.update.stream.RecoverableUpdateStreamImpl;
import com.pushtechnology.diffusion.client.features.impl.update.stream.UpdateStreamImpl;
import com.pushtechnology.diffusion.client.session.retry.RetryStrategy;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.constraints.Unconstrained;
import com.pushtechnology.diffusion.datatype.BinaryDelta;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.datatype.DeltaType;
import com.pushtechnology.diffusion.datatype.impl.DataTypesImpl;
import com.pushtechnology.diffusion.datatype.impl.TopicTypeToDataType;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.topics.update.conditional.AddAndSetTopicRequest;
import com.pushtechnology.diffusion.topics.update.update.stream.CreateUpdateStreamAndSetRequest;
import com.pushtechnology.diffusion.topics.update.update.stream.CreateUpdateStreamRequest;
import com.pushtechnology.diffusion.topics.update.update.stream.CreateUpdateStreamResponse;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamAddTopicRequest;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamAddTopicResponse;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamId;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamRequest;
import java.util.Objects;
import java.util.function.BiFunction;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class UpdateStreamBuilder
implements UpdateStream.Builder {
    private static final TopicSpecification DEFAULT_SPECIFICATION = null;
    private static final UpdateConstraint DEFAULT_CONSTRAINT = Unconstrained.get();
    private static final boolean DEFAULT_SUPPRESS_DELTAS = false;
    private final ServiceReference<CreateUpdateStreamRequest, CreateUpdateStreamResponse> createStreamService;
    private final ServiceReference<CreateUpdateStreamAndSetRequest, CreateUpdateStreamResponse> createStreamAndSetService;
    private final ServiceReference<UpdateStreamAddTopicRequest, UpdateStreamAddTopicResponse> streamAddTopicService;
    private final ServiceReference<AddAndSetTopicRequest, UpdateStreamAddTopicResponse> streamAddAndSetTopicService;
    private final ServiceReference<UpdateStreamId, Void> validateService;
    private final ServiceReference<UpdateStreamRequest, Void> setService;
    private final ServiceReference<UpdateStreamRequest, Void> deltaService;
    private final TopicTypeToDataType topicTypeToDataType;
    private final DataTypes dataTypes;
    private TopicSpecification theTopicSpecification = DEFAULT_SPECIFICATION;
    private UpdateConstraint theUpdateConstraint = DEFAULT_CONSTRAINT;
    private boolean theSuppressDeltas = false;

    public UpdateStreamBuilder(ServiceReference<CreateUpdateStreamRequest, CreateUpdateStreamResponse> createStreamService, ServiceReference<CreateUpdateStreamAndSetRequest, CreateUpdateStreamResponse> createStreamAndSetService, ServiceReference<UpdateStreamAddTopicRequest, UpdateStreamAddTopicResponse> streamAddTopicService, ServiceReference<AddAndSetTopicRequest, UpdateStreamAddTopicResponse> streamAddAndSetTopicService, ServiceReference<UpdateStreamId, Void> validateService, ServiceReference<UpdateStreamRequest, Void> setService, ServiceReference<UpdateStreamRequest, Void> deltaService, TopicTypeToDataType topicTypeToDataType, DataTypes dataTypes) {
        this.createStreamService = createStreamService;
        this.createStreamAndSetService = createStreamAndSetService;
        this.streamAddTopicService = streamAddTopicService;
        this.streamAddAndSetTopicService = streamAddAndSetTopicService;
        this.validateService = validateService;
        this.setService = setService;
        this.deltaService = deltaService;
        this.topicTypeToDataType = topicTypeToDataType;
        this.dataTypes = dataTypes;
    }

    @Override
    public UpdateStream.Builder specification(TopicSpecification topicSpecification) {
        this.theTopicSpecification = topicSpecification;
        return this;
    }

    @Override
    public UpdateStream.Builder constraint(UpdateConstraint updateConstraint) {
        this.theUpdateConstraint = updateConstraint == null ? Unconstrained.get() : updateConstraint;
        return this;
    }

    @Override
    public UpdateStream.Builder suppressDeltas(boolean suppressDeltas) {
        this.theSuppressDeltas = suppressDeltas;
        return this;
    }

    @Override
    public UpdateStream.Builder reset() {
        this.theTopicSpecification = DEFAULT_SPECIFICATION;
        this.theUpdateConstraint = DEFAULT_CONSTRAINT;
        this.theSuppressDeltas = false;
        return this;
    }

    @Override
    public <T> UpdateStream<T> build(String path, Class<T> valueClass) {
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(valueClass, "value class is null");
        return this.theTopicSpecification == null ? this.createUpdateStream(path, valueClass, this.theUpdateConstraint) : this.createUpdateStream(path, this.theTopicSpecification, valueClass, this.theUpdateConstraint);
    }

    @Override
    public <T> RecoverableUpdateStream<T> build(String path, Class<T> valueClass, RetryStrategy strategy) {
        Objects.requireNonNull(strategy, "strategy is null");
        return new RecoverableUpdateStreamImpl(() -> this.build(path, valueClass), strategy);
    }

    <T> UpdateStream<T> createUpdateStream(String path, Class<T> valueClass, UpdateConstraint updateConstraint) {
        DataType dataType = this.dataTypes.getByClass(valueClass);
        TopicType topicType = DataTypesImpl.toTopicType(dataType);
        DeltaType<T, BinaryDelta> deltaType = dataType.binaryDeltaType();
        BiFunction toDeltaOrValueBytes = UpdateStreamBuilder.getToBytesFunction(dataType, deltaType, this.theSuppressDeltas);
        ServiceReference<UpdateStreamRequest, Void> updateService = this.getUpdateService(deltaType);
        return new UpdateStreamImpl(stream -> new NewStream(this.createStreamService, this.createStreamAndSetService, this.validateService, this.setService, updateService, path, topicType, dataType, updateConstraint, toDeltaOrValueBytes, stream));
    }

    <T> UpdateStream<T> createUpdateStream(String path, TopicSpecification topicSpecification, Class<T> valueClass, UpdateConstraint updateConstraint) {
        DataType valueDataType;
        DataType<?> specDataType = this.topicTypeToDataType.get(topicSpecification.getType());
        if (specDataType != (valueDataType = this.dataTypes.getByClass(valueClass)) && topicSpecification.getType() != TopicType.TIME_SERIES) {
            throw new IllegalArgumentException("The specification and value have different data types");
        }
        DeltaType<T, BinaryDelta> deltaType = valueDataType.binaryDeltaType();
        BiFunction toDeltaOrValueBytes = UpdateStreamBuilder.getToBytesFunction(valueDataType, deltaType, this.theSuppressDeltas);
        ServiceReference<UpdateStreamRequest, Void> updateService = this.getUpdateService(deltaType);
        return new UpdateStreamImpl(stream -> new NewAddAndSetStream(this.streamAddTopicService, this.streamAddAndSetTopicService, this.validateService, this.setService, updateService, path, topicSpecification, valueDataType, updateConstraint, toDeltaOrValueBytes, stream));
    }

    private <T> ServiceReference<UpdateStreamRequest, Void> getUpdateService(DeltaType<T, BinaryDelta> deltaType) {
        if (deltaType == null || this.theSuppressDeltas) {
            return this.setService;
        }
        return this.deltaService;
    }

    private static <T> BiFunction<T, T, IBytes> getToBytesFunction(DataType<T> dataType, DeltaType<T, BinaryDelta> deltaType, boolean suppressDeltas) {
        if (deltaType == null || suppressDeltas) {
            return (oldValue, newValue) -> (IBytes)dataType.toBytes(newValue);
        }
        return (oldValue, newValue) -> {
            BinaryDelta delta = (BinaryDelta)deltaType.diff(oldValue, newValue);
            return (IBytes)deltaType.toBytes(delta);
        };
    }

    TopicSpecification getSpecification() {
        return this.theTopicSpecification;
    }

    UpdateConstraint getConstraint() {
        return this.theUpdateConstraint;
    }

    boolean getSuppressDeltas() {
        return this.theSuppressDeltas;
    }
}

