/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.impl.update.stream;

import com.pushtechnology.diffusion.client.features.InvalidUpdateStreamException;
import com.pushtechnology.diffusion.client.features.TopicCreationResult;
import com.pushtechnology.diffusion.client.features.impl.update.stream.InternalUpdateStream;
import com.pushtechnology.diffusion.client.features.impl.update.stream.InvalidUnsetStream;
import com.pushtechnology.diffusion.client.features.impl.update.stream.PendingValidateAndSetStream;
import com.pushtechnology.diffusion.client.features.impl.update.stream.UpdateStreamImpl;
import com.pushtechnology.diffusion.client.features.impl.update.stream.ValidatedStream;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.primitive.impl.DoubleDataTypeImpl;
import com.pushtechnology.diffusion.datatype.primitive.impl.Int64DataTypeImpl;
import com.pushtechnology.diffusion.datatype.primitive.impl.StringDataTypeImpl;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.topics.update.update.stream.CreateUpdateStreamResponse;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamId;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamRequest;
import com.pushtechnology.diffusion.util.concurrent.threads.WaitProtectedCompletableFuture;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.jcip.annotations.Immutable;

@Immutable
final class PendingValidateStream<T>
implements InternalUpdateStream<T> {
    private final UpdateStreamImpl<T> stream;
    private final ServiceReference<UpdateStreamId, Void> validateService;
    private final ServiceReference<UpdateStreamRequest, Void> setService;
    private final ServiceReference<UpdateStreamRequest, Void> updateService;
    private final BiFunction<T, T, IBytes> toDeltaOrValueBytes;
    private final DataType<T> dataType;
    private final CompletableFuture<TopicCreationResult> pendingResult;

    PendingValidateStream(UpdateStreamImpl<T> stream, ServiceReference<UpdateStreamId, Void> validateService, ServiceReference<UpdateStreamRequest, Void> setService, ServiceReference<UpdateStreamRequest, Void> updateService, BiFunction<T, T, IBytes> toDeltaOrValueBytes, DataType<T> dataType, CompletableFuture<TopicCreationResult> pendingResult) {
        this.stream = stream;
        this.validateService = validateService;
        this.updateService = updateService;
        this.setService = setService;
        this.toDeltaOrValueBytes = toDeltaOrValueBytes;
        this.dataType = dataType;
        this.pendingResult = pendingResult;
    }

    @Override
    public T get() {
        throw new IllegalStateException("The set method has not been called");
    }

    @Override
    public CompletableFuture<TopicCreationResult> set(T value) {
        if (!(value != null || this.dataType instanceof Int64DataTypeImpl || this.dataType instanceof DoubleDataTypeImpl || this.dataType instanceof StringDataTypeImpl)) {
            throw new IllegalArgumentException("null can only be passed for int64, double or string topics");
        }
        WaitProtectedCompletableFuture<TopicCreationResult> newResult = new WaitProtectedCompletableFuture<TopicCreationResult>();
        this.stream.setDelegate(new PendingValidateAndSetStream<T>(this.stream, this.pendingResult, newResult, this.dataType, this.toDeltaOrValueBytes, this.validateService, this.setService, this.updateService, value));
        return newResult;
    }

    @Override
    public boolean onSetComplete(CreateUpdateStreamResponse response) {
        throw new IllegalStateException("No set request has been sent");
    }

    @Override
    public boolean onSetFailed(Throwable ex) {
        throw new IllegalStateException("No set request has been sent");
    }

    @Override
    public CompletableFuture<TopicCreationResult> validate() {
        return this.pendingResult.exceptionally(ex -> {
            throw new InvalidUpdateStreamException((Throwable)ex);
        });
    }

    @Override
    public boolean onValidateComplete(CreateUpdateStreamResponse response) {
        BiFunction<Object, Object, IBytes> bf = response.isRetainsValue() ? this.toDeltaOrValueBytes : (ignored, v) -> (IBytes)this.dataType.toBytes(v);
        return this.stream.casDelegate(this, new ValidatedStream<T>(this.stream, response, this.validateService, this.setService, response.isRetainsValue() ? this.updateService : this.setService, this.dataType, bf));
    }

    @Override
    public boolean onValidateFailed(Throwable ex) {
        return this.stream.casDelegate(this, new InvalidUnsetStream(ex));
    }
}

