/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.impl.update.stream;

import com.pushtechnology.diffusion.client.features.TopicCreationResult;
import com.pushtechnology.diffusion.client.features.UpdateConstraint;
import com.pushtechnology.diffusion.client.features.impl.update.stream.InternalUpdateStream;
import com.pushtechnology.diffusion.client.features.impl.update.stream.PendingSetStream;
import com.pushtechnology.diffusion.client.features.impl.update.stream.PendingValidateStream;
import com.pushtechnology.diffusion.client.features.impl.update.stream.UpdateStreamImpl;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.primitive.impl.DoubleDataTypeImpl;
import com.pushtechnology.diffusion.datatype.primitive.impl.Int64DataTypeImpl;
import com.pushtechnology.diffusion.datatype.primitive.impl.StringDataTypeImpl;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.topics.update.update.stream.CreateUpdateStreamAndSetRequest;
import com.pushtechnology.diffusion.topics.update.update.stream.CreateUpdateStreamRequest;
import com.pushtechnology.diffusion.topics.update.update.stream.CreateUpdateStreamResponse;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamId;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamRequest;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import net.jcip.annotations.Immutable;

@Immutable
final class NewStream<T>
implements InternalUpdateStream<T> {
    private final ServiceReference<CreateUpdateStreamRequest, CreateUpdateStreamResponse> createStreamService;
    private final ServiceReference<CreateUpdateStreamAndSetRequest, CreateUpdateStreamResponse> createStreamAndSetService;
    private final ServiceReference<UpdateStreamId, Void> validateService;
    private final ServiceReference<UpdateStreamRequest, Void> setService;
    private final ServiceReference<UpdateStreamRequest, Void> updateService;
    private final String path;
    private final TopicType topicType;
    private final DataType<T> dataType;
    private final UpdateConstraint constraint;
    private final BiFunction<T, T, IBytes> toDeltaOrValueBytes;
    private final UpdateStreamImpl<T> stream;

    NewStream(ServiceReference<CreateUpdateStreamRequest, CreateUpdateStreamResponse> createStreamService, ServiceReference<CreateUpdateStreamAndSetRequest, CreateUpdateStreamResponse> createStreamAndSetService, ServiceReference<UpdateStreamId, Void> validateService, ServiceReference<UpdateStreamRequest, Void> setService, ServiceReference<UpdateStreamRequest, Void> updateService, String path, TopicType topicType, DataType<T> dataType, UpdateConstraint constraint, BiFunction<T, T, IBytes> toDeltaOrValueBytes, UpdateStreamImpl<T> stream) {
        this.createStreamService = createStreamService;
        this.createStreamAndSetService = createStreamAndSetService;
        this.validateService = validateService;
        this.setService = setService;
        this.updateService = updateService;
        this.path = path;
        this.topicType = topicType;
        this.dataType = dataType;
        this.constraint = constraint;
        this.toDeltaOrValueBytes = toDeltaOrValueBytes;
        this.stream = stream;
    }

    @Override
    public T get() {
        throw new IllegalStateException("The set method has not been called");
    }

    @Override
    public CompletableFuture<TopicCreationResult> set(T value) {
        if (!(value != null || this.dataType instanceof Int64DataTypeImpl || this.dataType instanceof DoubleDataTypeImpl || this.dataType instanceof StringDataTypeImpl)) {
            throw new IllegalArgumentException("null can only be passed for int64, double or string topics");
        }
        IBytes bytes = (IBytes)this.dataType.toBytes(value);
        CompletableFuture<CreateUpdateStreamResponse> serverResponse = this.createStreamAndSetService.sendCommand(new CreateUpdateStreamAndSetRequest(this.path, this.topicType, bytes, this.constraint));
        CompletionStage result = serverResponse.thenApply(x -> TopicCreationResult.EXISTS);
        this.stream.setDelegate(new PendingSetStream<Object>(this.stream, (CompletableFuture<TopicCreationResult>)result, value, this.dataType, (ignored, v) -> (IBytes)this.dataType.toBytes(v), this.toDeltaOrValueBytes, this.validateService, this.updateService, this.setService));
        serverResponse.whenComplete((r, ex) -> {
            if (ex != null) {
                this.stream.onSetFailed((Throwable)ex);
            } else {
                this.stream.onSetComplete((CreateUpdateStreamResponse)r);
            }
        });
        return result;
    }

    @Override
    public boolean onSetComplete(CreateUpdateStreamResponse response) {
        return false;
    }

    @Override
    public boolean onSetFailed(Throwable ex) {
        return false;
    }

    @Override
    public CompletableFuture<TopicCreationResult> validate() {
        CompletableFuture<CreateUpdateStreamResponse> serverResponse = this.createStreamService.sendCommand(new CreateUpdateStreamRequest(this.path, this.topicType, this.constraint));
        CompletionStage result = serverResponse.thenApply(x -> TopicCreationResult.EXISTS);
        this.stream.setDelegate(new PendingValidateStream<T>(this.stream, this.validateService, this.setService, this.updateService, this.toDeltaOrValueBytes, this.dataType, (CompletableFuture<TopicCreationResult>)result));
        serverResponse.whenComplete((r, ex) -> {
            if (ex != null) {
                this.stream.onValidateFailed((Throwable)ex);
            } else {
                this.stream.onValidateComplete((CreateUpdateStreamResponse)r);
            }
        });
        return result;
    }

    @Override
    public boolean onValidateComplete(CreateUpdateStreamResponse streamId) {
        return false;
    }

    @Override
    public boolean onValidateFailed(Throwable ex) {
        return false;
    }
}

