/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.impl.update.stream;

import com.pushtechnology.diffusion.client.features.TopicCreationResult;
import com.pushtechnology.diffusion.client.features.UpdateConstraint;
import com.pushtechnology.diffusion.client.features.impl.update.stream.InternalUpdateStream;
import com.pushtechnology.diffusion.client.features.impl.update.stream.PendingSetStream;
import com.pushtechnology.diffusion.client.features.impl.update.stream.PendingValidateStream;
import com.pushtechnology.diffusion.client.features.impl.update.stream.UpdateStreamImpl;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.topics.update.conditional.AddAndSetTopicRequest;
import com.pushtechnology.diffusion.topics.update.update.stream.CreateUpdateStreamResponse;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamAddTopicRequest;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamAddTopicResponse;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamId;
import com.pushtechnology.diffusion.topics.update.update.stream.UpdateStreamRequest;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import net.jcip.annotations.Immutable;

@Immutable
final class NewAddAndSetStream<T>
implements InternalUpdateStream<T> {
    private final ServiceReference<UpdateStreamAddTopicRequest, UpdateStreamAddTopicResponse> streamAddTopicService;
    private final ServiceReference<AddAndSetTopicRequest, UpdateStreamAddTopicResponse> streamAddAndSetTopicService;
    private final ServiceReference<UpdateStreamId, Void> validateService;
    private final ServiceReference<UpdateStreamRequest, Void> setService;
    private final ServiceReference<UpdateStreamRequest, Void> updateService;
    private final String path;
    private final TopicSpecification topicSpecification;
    private final DataType<T> dataType;
    private final UpdateConstraint constraint;
    private final BiFunction<T, T, IBytes> toDeltaOrValueBytes;
    private final UpdateStreamImpl<T> stream;

    NewAddAndSetStream(ServiceReference<UpdateStreamAddTopicRequest, UpdateStreamAddTopicResponse> streamAddTopicService, ServiceReference<AddAndSetTopicRequest, UpdateStreamAddTopicResponse> streamAddAndSetTopicService, ServiceReference<UpdateStreamId, Void> validateService, ServiceReference<UpdateStreamRequest, Void> setService, ServiceReference<UpdateStreamRequest, Void> updateService, String path, TopicSpecification topicSpecification, DataType<T> dataType, UpdateConstraint constraint, BiFunction<T, T, IBytes> toDeltaOrValueBytes, UpdateStreamImpl<T> stream) {
        this.streamAddTopicService = streamAddTopicService;
        this.streamAddAndSetTopicService = streamAddAndSetTopicService;
        this.validateService = validateService;
        this.setService = setService;
        this.updateService = updateService;
        this.path = path;
        this.topicSpecification = topicSpecification;
        this.dataType = dataType;
        this.constraint = constraint;
        this.toDeltaOrValueBytes = toDeltaOrValueBytes;
        this.stream = stream;
    }

    @Override
    public T get() {
        throw new IllegalStateException("The set method has not been called");
    }

    @Override
    public CompletableFuture<TopicCreationResult> set(T value) {
        IBytes bytes = (IBytes)this.dataType.toBytes(value);
        CompletableFuture<UpdateStreamAddTopicResponse> serverResponse = this.streamAddAndSetTopicService.sendCommand(new AddAndSetTopicRequest(this.path, this.topicSpecification, bytes, this.constraint));
        CompletionStage result = serverResponse.thenApply(UpdateStreamAddTopicResponse::getCreationResult);
        this.stream.setDelegate(new PendingSetStream<Object>(this.stream, (CompletableFuture<TopicCreationResult>)result, value, this.dataType, (ignored, v) -> (IBytes)this.dataType.toBytes(v), this.toDeltaOrValueBytes, this.validateService, this.updateService, this.setService));
        serverResponse.whenComplete((response, ex) -> {
            if (ex != null) {
                this.stream.onSetFailed((Throwable)ex);
            } else {
                this.stream.onSetComplete((CreateUpdateStreamResponse)response);
            }
        });
        return result;
    }

    @Override
    public boolean onSetComplete(CreateUpdateStreamResponse response) {
        return false;
    }

    @Override
    public boolean onSetFailed(Throwable ex) {
        return false;
    }

    @Override
    public CompletableFuture<TopicCreationResult> validate() {
        CompletableFuture<UpdateStreamAddTopicResponse> serverResponse = this.streamAddTopicService.sendCommand(new UpdateStreamAddTopicRequest(this.path, this.topicSpecification, this.constraint));
        CompletionStage result = serverResponse.thenApply(UpdateStreamAddTopicResponse::getCreationResult);
        this.stream.setDelegate(new PendingValidateStream<T>(this.stream, this.validateService, this.setService, this.updateService, this.toDeltaOrValueBytes, this.dataType, (CompletableFuture<TopicCreationResult>)result));
        serverResponse.whenComplete((response, ex) -> {
            if (ex != null) {
                this.stream.onValidateFailed((Throwable)ex);
            } else {
                this.stream.onValidateComplete((CreateUpdateStreamResponse)response);
            }
        });
        return result;
    }

    @Override
    public boolean onValidateComplete(CreateUpdateStreamResponse response) {
        return false;
    }

    @Override
    public boolean onValidateFailed(Throwable ex) {
        return false;
    }
}

