/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.impl.update.stream;

import com.pushtechnology.diffusion.client.features.InvalidUpdateStreamException;
import com.pushtechnology.diffusion.client.features.TopicCreationResult;
import com.pushtechnology.diffusion.client.features.impl.update.stream.InternalUpdateStream;
import com.pushtechnology.diffusion.java7.Functions;
import com.pushtechnology.diffusion.topics.update.update.stream.CreateUpdateStreamResponse;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

@Immutable
final class InvalidSetStream<T>
implements InternalUpdateStream<T> {
    private final CompletableFuture<TopicCreationResult> result = new CompletableFuture();
    private final T currentValue;

    InvalidSetStream(Throwable e, T currentValue) {
        this.result.completeExceptionally(new InvalidUpdateStreamException(e));
        this.currentValue = currentValue;
    }

    @Override
    public T get() {
        return this.currentValue;
    }

    @Override
    public CompletableFuture<TopicCreationResult> set(T value) {
        return this.result.thenApply(Functions.identity());
    }

    @Override
    public boolean onSetComplete(CreateUpdateStreamResponse response) {
        return true;
    }

    @Override
    public boolean onSetFailed(Throwable ex) {
        return true;
    }

    @Override
    public CompletableFuture<TopicCreationResult> validate() {
        return this.result;
    }

    @Override
    public boolean onValidateComplete(CreateUpdateStreamResponse response) {
        return true;
    }

    @Override
    public boolean onValidateFailed(Throwable ex) {
        return true;
    }
}

